/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionFactory;
import jakarta.resource.cci.ConnectionSpec;
import jakarta.resource.cci.RecordFactory;
import jakarta.resource.cci.ResourceAdapterMetaData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.naming.Reference;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoCodecs;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecordFactory;

public class MongoConnectionFactory
implements ConnectionFactory {
    protected transient MongoClient mongo;
    protected transient MongoDatabase db;

    public MongoConnectionFactory() {
    }

    public MongoConnectionFactory(MongoClient mongo) {
        this.mongo = mongo;
    }

    public MongoConnectionFactory(MongoDatabase db) {
        this.db = db;
    }

    public Connection getConnection() throws ResourceException {
        return this.getConnection(new MongoJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        boolean isExternal;
        MongoJCAConnectionSpec connectionSpec;
        block16: {
            connectionSpec = (MongoJCAConnectionSpec)spec;
            MongoDatabase db = this.db;
            isExternal = true;
            if (db == null) {
                try {
                    MongoClient mongo;
                    ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
                    for (int index = 0; index < connectionSpec.getHosts().size(); ++index) {
                        String host = connectionSpec.getHosts().get(index);
                        int port = ServerAddress.defaultPort();
                        if (connectionSpec.getPorts().size() > index) {
                            port = connectionSpec.getPorts().get(index);
                        }
                        ServerAddress server = new ServerAddress(host, port);
                        servers.add(server);
                    }
                    if (connectionSpec.getHosts().isEmpty()) {
                        ServerAddress server = new ServerAddress("localhost", ServerAddress.defaultPort());
                        servers.add(server);
                    }
                    if ((mongo = this.mongo) == null) {
                        isExternal = false;
                        MongoCredential credential = null;
                        if (connectionSpec.getUser() != null && !connectionSpec.getUser().isEmpty()) {
                            credential = connectionSpec.getAuthSource() != null ? MongoCredential.createCredential((String)connectionSpec.getUser(), (String)connectionSpec.getAuthSource(), (char[])connectionSpec.getPassword()) : MongoCredential.createCredential((String)connectionSpec.getUser(), (String)connectionSpec.getDB(), (char[])connectionSpec.getPassword());
                        }
                        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
                        settingsBuilder.applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)connectionSpec.getServerSelectionTimeout(), TimeUnit.MILLISECONDS));
                        if (connectionSpec.getReadPreference() != null) {
                            settingsBuilder.readPreference(connectionSpec.getReadPreference());
                        }
                        if (connectionSpec.getWriteConcern() != null) {
                            settingsBuilder.writeConcern(connectionSpec.getWriteConcern());
                        }
                        settingsBuilder.codecRegistry(MongoCodecs.codecRegistry());
                        MongoClientSettings settings = null;
                        if (credential != null) {
                            settingsBuilder.credential(credential);
                        }
                        if (servers.isEmpty()) {
                            ServerAddress serverAddress = new ServerAddress();
                            settings = settingsBuilder.applyConnectionString(new ConnectionString("mongodb+srv://" + serverAddress.getHost() + ":" + serverAddress.getPort())).build();
                            mongo = MongoClients.create((MongoClientSettings)settings);
                        } else {
                            settings = settingsBuilder.applyToClusterSettings(builder -> builder.hosts(servers)).build();
                            mongo = MongoClients.create((MongoClientSettings)settings);
                        }
                        this.mongo = mongo;
                    }
                    db = mongo.getDatabase(connectionSpec.getDB());
                    db.runCommand((Bson)new Document("ping", (Object)1));
                    if (connectionSpec.getUser() == null || connectionSpec.getUser().isEmpty()) break block16;
                    try {
                        Method method = MongoDatabase.class.getMethod("authenticate", String.class, char[].class);
                        if (!((Boolean)method.invoke((Object)db, connectionSpec.getUser(), connectionSpec.getPassword())).booleanValue()) {
                            throw new ResourceException("authenticate failed for user: " + connectionSpec.getUser());
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        throw new ResourceException("authenticate method not supported: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception exception) {
                    ResourceException resourceException = new ResourceException(exception.toString());
                    resourceException.initCause((Throwable)exception);
                    throw resourceException;
                }
            }
        }
        return new MongoConnection(this.mongo, connectionSpec.getDB(), isExternal, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new MongoAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new MongoRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }
}

