/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.Record;
import jakarta.resource.cci.ResourceWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoListRecord;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoOperation;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecord;

public class MongoInteraction
implements Interaction {
    protected MongoConnection connection;

    public MongoInteraction(MongoConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        MongoRecord record;
        MongoInteractionSpec mongoSpec;
        block10: {
            block9: {
                if (!(spec instanceof MongoInteractionSpec)) {
                    throw EISException.invalidInteractionSpecType();
                }
                mongoSpec = (MongoInteractionSpec)spec;
                if (!(input instanceof MongoRecord)) break block9;
                record = (MongoRecord)input;
                if (output instanceof MongoRecord) break block10;
            }
            throw EISException.invalidRecordType();
        }
        MongoRecord translationRecord = (MongoRecord)output;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            throw new ResourceException("Mongo operation must be set");
        }
        if (collectionName == null) {
            throw new ResourceException("DB Collection name must be set");
        }
        try {
            MongoCollection collection = this.connection.getDB().getCollection(collectionName);
            Document object = this.buildDocument(record);
            Document translation = this.buildDocument(translationRecord);
            if (operation == MongoOperation.UPDATE) {
                UpdateResult result = null;
                Document document = new Document("$set", (Object)object);
                UpdateOptions updateOptions = new UpdateOptions().upsert(mongoSpec.isUpsert());
                result = mongoSpec.isMulti() ? collection.updateMany((Bson)translation, (Bson)document, updateOptions) : collection.updateOne((Bson)translation, (Bson)document, updateOptions);
                return result.getModifiedCount() > 0L;
            }
            throw new ResourceException("Invalid operation: " + String.valueOf((Object)operation));
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        if (!(spec instanceof MongoInteractionSpec)) throw EISException.invalidInteractionSpecType();
        MongoInteractionSpec mongoSpec = (MongoInteractionSpec)spec;
        if (!(record instanceof MongoRecord)) throw EISException.invalidRecordType();
        MongoRecord input = (MongoRecord)record;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            throw new ResourceException("Mongo operation must be set");
        }
        if (operation == MongoOperation.EVAL) {
            Document document = this.connection.getDB().runCommand((Bson)Document.parse((String)mongoSpec.getCode()));
            MongoListRecord results = null;
            if (document.get((Object)"cursor") == null) return results;
            if (((Document)document.get((Object)"cursor")).get((Object)"firstBatch") == null) return results;
            List resultList = (List)((Document)document.get((Object)"cursor")).get((Object)"firstBatch");
            results = new MongoListRecord();
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                Document result = (Document)iterator.next();
                results.add(this.buildRecordFromDocument(result));
            }
            return results;
        }
        if (collectionName == null) {
            throw new ResourceException("DB Collection name must be set");
        }
        try {
            MongoCollection collection = this.connection.getDB().getCollection(collectionName);
            if (mongoSpec.getOptions() > 0) {
                // empty if block
            }
            if (mongoSpec.getReadPreference() != null) {
                collection = collection.withReadPreference(mongoSpec.getReadPreference());
            }
            if (mongoSpec.getWriteConcern() != null) {
                collection = collection.withWriteConcern(mongoSpec.getWriteConcern());
            }
            if (operation == MongoOperation.INSERT) {
                Document document = this.buildDocument(input);
                collection.insertOne((Object)document);
                return null;
            }
            if (operation == MongoOperation.REMOVE) {
                Document document = this.buildDocument(input);
                collection.deleteOne((Bson)document);
                return null;
            }
            if (operation != MongoOperation.FIND) throw new ResourceException("Invalid operation: " + String.valueOf((Object)operation));
            Document sort = null;
            if (input.containsKey("$sort")) {
                sort = this.buildDocument((MongoRecord)input.get("$sort"));
                input.remove("$sort");
            }
            Document select = null;
            if (input.containsKey("$select")) {
                select = this.buildDocument((MongoRecord)input.get("$select"));
                input.remove("$select");
            }
            Document document = this.buildDocument(input);
            FindIterable iterable = collection.find((Bson)document);
            if (sort != null) {
                iterable.sort((Bson)sort);
            }
            try (MongoCursor cursor = iterable.iterator();){
                if (mongoSpec.getSkip() > 0) {
                    iterable.skip(mongoSpec.getSkip());
                }
                if (mongoSpec.getLimit() != 0) {
                    iterable.limit(mongoSpec.getLimit());
                }
                if (mongoSpec.getBatchSize() != 0) {
                    iterable.batchSize(mongoSpec.getBatchSize());
                }
                if (!cursor.hasNext()) {
                    Record record2 = null;
                    return record2;
                }
                MongoListRecord results = new MongoListRecord();
                while (cursor.hasNext()) {
                    Document result = (Document)cursor.next();
                    results.add(this.buildRecordFromDocument(result));
                }
                MongoListRecord mongoListRecord = results;
                return mongoListRecord;
            }
        }
        catch (Exception exception) {
            throw new ResourceException((Throwable)exception);
        }
    }

    public Document buildDocument(MongoRecord record) {
        Document document = new Document();
        for (Map.Entry entry : record.entrySet()) {
            if (entry.getValue() instanceof MongoRecord) {
                document.put((String)entry.getKey(), (Object)this.buildDocument((MongoRecord)entry.getValue()));
                continue;
            }
            document.put((String)entry.getKey(), entry.getValue());
        }
        return document;
    }

    public MongoRecord buildRecordFromDocument(Document document) {
        MongoRecord record = new MongoRecord();
        for (Map.Entry entry : document.entrySet()) {
            if (entry.getValue() instanceof BasicDBList) {
                ArrayList<MongoRecord> values = new ArrayList<MongoRecord>();
                for (Object value : (BasicDBList)entry.getValue()) {
                    if (value instanceof Document) {
                        values.add(this.buildRecordFromDocument((Document)value));
                        continue;
                    }
                    values.add((MongoRecord)value);
                }
                record.put(entry.getKey(), values);
                continue;
            }
            if (entry.getValue() instanceof Document) {
                MongoRecord nestedRecord = this.buildRecordFromDocument((Document)entry.getValue());
                record.put(entry.getKey(), nestedRecord);
                continue;
            }
            record.put(entry.getKey(), entry.getValue());
        }
        return record;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }
}

