/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.xmlfile;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.LocalTransaction;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileConnection;

public class XMLFileTransaction
implements LocalTransaction {
    protected boolean isInTransaction;
    protected Map domFiles;
    protected XMLFileConnection connection;

    public XMLFileTransaction(XMLFileConnection connection) {
        this.connection = connection;
        this.isInTransaction = false;
    }

    public void begin() {
        this.isInTransaction = true;
        this.domFiles = new HashMap(10);
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public void commit() throws ResourceException {
        try {
            for (Map.Entry entry : this.domFiles.entrySet()) {
                String fileName = (String)entry.getKey();
                EISDOMRecord record = (EISDOMRecord)entry.getValue();
                try (FileWriter fileWriter = new FileWriter(fileName);){
                    record.transformToWriter((Writer)fileWriter);
                    ((Writer)fileWriter).flush();
                }
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        this.domFiles = new HashMap(10);
        this.isInTransaction = false;
    }

    public void rollback() {
        this.domFiles = new HashMap(10);
        this.isInTransaction = false;
    }

    public EISDOMRecord retrieveDOMRecord(File file) throws Exception {
        EISDOMRecord fileRecord = (EISDOMRecord)this.domFiles.get(file.getPath());
        if (fileRecord == null) {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                fileRecord = new EISDOMRecord();
                fileRecord.transformFromXML((Reader)fileReader);
                ((Reader)fileReader).close();
            } else {
                fileRecord = new EISDOMRecord();
                fileRecord.setDOM(fileRecord.createNewDocument("root"));
            }
            this.domFiles.put(file.getPath(), fileRecord);
        }
        return fileRecord;
    }
}

