/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.adapters.jms;

import jakarta.jms.TextMessage;
import jakarta.resource.ResourceException;
import jakarta.resource.cci.IndexedRecord;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSReceiveInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendReceiveInteractionSpec;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;

public class JMSPlatform
extends EISPlatform {
    public static final String MODE = "mode";
    public static final String SEND = "send";
    public static final String RECEIVE = "receive";
    public static final String SEND_RECEIVE = "sendAndReceive";
    public static final String SELECTOR = "selector";
    public static final String TIMEOUT = "timeout";
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_URL = "destinationURL";
    public static final String REPLY_TO_DESTINATION = "replyToDestination";
    public static final String REPLY_TO_DESTINATION_URL = "replyToDestinationURL";

    public JMSPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(false);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        CciJMSInteractionSpec jmsSpec;
        InteractionSpec spec = interaction.getInteractionSpec();
        if (spec != null) return spec;
        if (interaction.getProperty(MODE) == null) {
            throw EISException.propertyNotSet((String)MODE);
        }
        if (interaction.getProperty(MODE).equals(SEND)) {
            jmsSpec = new CciJMSSendInteractionSpec();
        } else if (interaction.getProperty(MODE).equals(RECEIVE)) {
            jmsSpec = new CciJMSReceiveInteractionSpec();
        } else {
            if (!interaction.getProperty(MODE).equals(SEND_RECEIVE)) throw EISException.invalidProperty((String)MODE);
            jmsSpec = new CciJMSSendReceiveInteractionSpec();
        }
        String property = (String)interaction.getProperty(SELECTOR);
        if (property != null) {
            jmsSpec.setMessageSelector(property);
        }
        if (jmsSpec instanceof CciJMSSendInteractionSpec) {
            property = (String)interaction.getProperty(DESTINATION_URL);
            if (property != null) {
                jmsSpec.setDestinationURL(property);
            } else {
                property = (String)interaction.getProperty(DESTINATION);
                if (property == null) throw EISException.propertiesNotSet((String)DESTINATION_URL, (String)DESTINATION);
                jmsSpec.setDestination(property);
            }
            property = (String)interaction.getProperty(REPLY_TO_DESTINATION_URL);
            if (property != null) {
                ((CciJMSSendInteractionSpec)jmsSpec).setReplyToDestinationURL(property);
                return jmsSpec;
            } else {
                property = (String)interaction.getProperty(REPLY_TO_DESTINATION);
                if (property == null) throw EISException.propertiesNotSet((String)REPLY_TO_DESTINATION_URL, (String)REPLY_TO_DESTINATION);
                ((CciJMSSendInteractionSpec)jmsSpec).setReplyToDestination(property);
            }
            return jmsSpec;
        } else if (jmsSpec instanceof CciJMSReceiveInteractionSpec) {
            property = (String)interaction.getProperty(DESTINATION_URL);
            if (property != null) {
                jmsSpec.setDestinationURL(property);
            } else {
                property = (String)interaction.getProperty(DESTINATION);
                if (property == null) throw EISException.propertiesNotSet((String)DESTINATION_URL, (String)DESTINATION);
                jmsSpec.setDestination(property);
            }
            property = (String)interaction.getProperty(TIMEOUT);
            if (property == null) return jmsSpec;
            ((CciJMSReceiveInteractionSpec)jmsSpec).setTimeout(property);
            return jmsSpec;
        } else {
            property = (String)interaction.getProperty(DESTINATION_URL);
            if (property != null) {
                ((CciJMSSendReceiveInteractionSpec)jmsSpec).setDestinationURL(property);
            } else {
                property = (String)interaction.getProperty(DESTINATION);
                if (property == null) throw EISException.propertiesNotSet((String)DESTINATION_URL, (String)DESTINATION);
                ((CciJMSSendReceiveInteractionSpec)jmsSpec).setDestination(property);
            }
            property = (String)interaction.getProperty(REPLY_TO_DESTINATION_URL);
            if (property != null) {
                ((CciJMSSendReceiveInteractionSpec)jmsSpec).setReplyToDestinationURL(property);
            } else {
                property = (String)interaction.getProperty(REPLY_TO_DESTINATION);
                if (property == null) throw EISException.propertiesNotSet((String)REPLY_TO_DESTINATION_URL, (String)REPLY_TO_DESTINATION);
                ((CciJMSSendReceiveInteractionSpec)jmsSpec).setReplyToDestination(property);
            }
            property = (String)interaction.getProperty(TIMEOUT);
            if (property == null) return jmsSpec;
            ((CciJMSSendReceiveInteractionSpec)jmsSpec).setTimeout(property);
        }
        return jmsSpec;
    }

    public Record createDOMRecord(String recordName, EISAccessor accessor) {
        try {
            return accessor.getRecordFactory().createIndexedRecord(recordName);
        }
        catch (ResourceException exception) {
            throw EISException.createException((Exception)((Object)exception));
        }
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction call, EISAccessor accessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        indexedRecord.add((Object)new DOMRecord(dom).transformToXML());
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        if (indexedRecord.size() == 0) {
            return null;
        }
        EISDOMRecord domRecord = new EISDOMRecord();
        Object recordData = indexedRecord.get(0);
        if (recordData instanceof TextMessage) {
            try {
                domRecord.transformFromXML(((TextMessage)recordData).getText());
            }
            catch (Exception ex) {
                return null;
            }
        } else if (recordData instanceof String) {
            domRecord.transformFromXML((String)recordData);
        } else {
            throw EISException.unsupportedMessageInOutputRecord();
        }
        return domRecord;
    }
}

