/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilter;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultList;
import org.eclipse.persistence.jpa.rs.util.xmladapters.LinkAdapter;

public class StreamingOutputMarshaller
implements StreamingOutput {
    private final PersistenceContext context;
    private final Object result;
    private final MediaType mediaType;
    private FieldsFilter filter;

    public StreamingOutputMarshaller(PersistenceContext context, Object result, MediaType acceptedType) {
        this.context = context;
        this.result = result;
        this.mediaType = acceptedType;
    }

    public StreamingOutputMarshaller(PersistenceContext context, Object result, List<MediaType> acceptedTypes, FieldsFilter filter) {
        this(context, result, acceptedTypes);
        this.filter = filter;
    }

    public StreamingOutputMarshaller(PersistenceContext context, Object result, List<MediaType> acceptedTypes) {
        this(context, result, StreamingOutputMarshaller.mediaType(acceptedTypes));
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        if (this.result instanceof byte[] && this.mediaType.equals((Object)MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            output.write((byte[])this.result);
            output.flush();
            output.close();
        } else if (this.result instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
            writer.write((String)this.result);
            writer.flush();
            writer.close();
        } else {
            if (this.context != null && this.context.getJAXBContext() != null && this.result != null && (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE) || this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE))) {
                try {
                    if (this.result instanceof ReportQueryResultList) {
                        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
                            this.context.marshallEntity(((ReportQueryResultList)this.result).getItems(), this.mediaType, output);
                        } else {
                            this.context.marshallEntity(this.result, this.mediaType, output);
                        }
                    } else if (this.filter != null) {
                        this.context.marshallEntity(this.result, this.filter, this.mediaType, output);
                    } else {
                        this.context.marshallEntity(this.result, this.mediaType, output);
                    }
                    return;
                }
                catch (Exception ex) {
                    JPARSLogger.exception(this.context.getSessionLog(), "jpars_caught_exception", new Object[0], ex);
                    throw JPARSException.exceptionOccurred(ex);
                }
            }
            if (this.mediaType.equals((Object)MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.result);
                oos.flush();
                oos.close();
                output.write(baos.toByteArray());
            } else {
                if (this.context != null) {
                    JPARSLogger.error(this.context.getSessionLog(), "jpars_could_not_marshal_requested_result_to_requested_type", new Object[]{this.result});
                } else {
                    JPARSLogger.error("jpars_could_not_marshal_requested_result_to_requested_type", new Object[]{this.result});
                }
                throw new WebApplicationException();
            }
        }
    }

    public static MediaType mediaType(List<MediaType> types) {
        if (types != null) {
            for (MediaType type : types) {
                MediaType aMediaType = type;
                if (aMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                    return MediaType.APPLICATION_JSON_TYPE;
                }
                if (aMediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                if (aMediaType.isCompatible(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                    return MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
                if (!aMediaType.isCompatible(AbstractResource.APPLICATION_SCHEMA_JSON_TYPE)) continue;
                return AbstractResource.APPLICATION_SCHEMA_JSON_TYPE;
            }
        }
        return MediaType.APPLICATION_JSON_TYPE;
    }

    public static Marshaller createMarshaller(PersistenceContext context, MediaType mediaType) throws JAXBException {
        JAXBMarshaller marshaller = context.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setAdapter((XmlAdapter)new LinkAdapter(context.getBaseURI().toString(), context));
        marshaller.setListener(new Marshaller.Listener(){

            public void beforeMarshal(Object source) {
                if (source instanceof DynamicEntity) {
                    DynamicEntityImpl sourceImpl = (DynamicEntityImpl)source;
                    PropertyChangeListener listener = sourceImpl._persistence_getPropertyChangeListener();
                    sourceImpl._persistence_setPropertyChangeListener(null);
                    ((DynamicEntity)source).set("self", source);
                    sourceImpl._persistence_setPropertyChangeListener(listener);
                }
            }
        });
        return marshaller;
    }

    public static MediaType getResponseMediaType(HttpHeaders headers) {
        List accepts;
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (headers != null && (accepts = headers.getAcceptableMediaTypes()) != null && !accepts.isEmpty()) {
            try {
                mediaType = StreamingOutputMarshaller.mediaType(accepts);
            }
            catch (Exception ex) {
                JPARSLogger.exception("Exception in getResponseMediaType", new Object[]{headers}, ex);
            }
        }
        return mediaType;
    }
}

