/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.JSR109WebServicePackager;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.XRPackager;

public class IDEPackager
extends JSR109WebServicePackager {
    public static final String SRC_DIR = "src";
    protected File srcDir;
    protected String srcDirname;
    protected File publicHTMLDir;
    protected String publicHTMLDirname;
    protected File webInfDir;
    protected File wsdlDir;
    protected File underDBWSDir;

    public IDEPackager() {
    }

    public IDEPackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public String getArchiverLabel() {
        return "not supported";
    }

    @Override
    public String getAdditionalUsage() {
        return null;
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return null;
    }

    @Override
    public OutputStream getSchemaStream() throws FileNotFoundException {
        this.buildWSDLDir();
        return new FileOutputStream(new File(this.wsdlDir, "eclipselink-dbws-schema.xsd"));
    }

    @Override
    public OutputStream getSessionsStream(String sessionsFileName) throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, sessionsFileName));
    }

    @Override
    public OutputStream getServiceStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws.xml"));
    }

    @Override
    public OutputStream getOrStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws-or.xml"));
    }

    @Override
    public OutputStream getOxStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws-ox.xml"));
    }

    @Override
    public OutputStream getWSDLStream() throws FileNotFoundException {
        this.buildWSDLDir();
        return new FileOutputStream(new File(this.wsdlDir, "eclipselink-dbws.wsdl"));
    }

    @Override
    public OutputStream getSWARefStream() throws FileNotFoundException {
        if (this.hasAttachments) {
            this.buildWSDLDir();
            return new FileOutputStream(new File(this.wsdlDir, Util.SWAREF_FILENAME));
        }
        return XRPackager.__nullStream;
    }

    @Override
    public OutputStream getWebXmlStream() throws FileNotFoundException {
        this.buildWebInfDir();
        return new FileOutputStream(new File(this.webInfDir, "web.xml"));
    }

    @Override
    public OutputStream getProviderClassStream() throws FileNotFoundException {
        return XRPackager.__nullStream;
    }

    @Override
    public OutputStream getProviderSourceStream() throws FileNotFoundException {
        this.buildUnderDBWS();
        return new FileOutputStream(new File(this.underDBWSDir, "DBWSProvider.java"));
    }

    @Override
    public OutputStream getProviderListenerClassStream() throws FileNotFoundException {
        return XRPackager.__nullStream;
    }

    @Override
    public OutputStream getProviderListenerSourceStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.underDBWSDir, "ProviderListener.java"));
    }

    protected void buildSrcDir() throws FileNotFoundException {
        boolean worked;
        this.srcDir = new File(this.stageDir, this.srcDirname);
        if (!this.srcDir.exists() && !(worked = this.srcDir.mkdir())) {
            throw new FileNotFoundException("cannot create " + this.srcDirname + " under " + String.valueOf(this.stageDir));
        }
    }

    protected void buildUnderDBWS() throws FileNotFoundException {
        boolean worked;
        this.buildSrcDir();
        this.underDBWSDir = new File(this.srcDir, "_dbws");
        if (!this.underDBWSDir.exists() && !(worked = this.underDBWSDir.mkdir())) {
            throw new FileNotFoundException("cannot create " + this.srcDirname + "/_dbws dir under " + String.valueOf(this.stageDir));
        }
    }

    protected void buildPublicHTMLDir() throws FileNotFoundException {
        boolean worked;
        this.publicHTMLDir = new File(this.stageDir, this.publicHTMLDirname);
        if (!this.publicHTMLDir.exists() && !(worked = this.publicHTMLDir.mkdir())) {
            throw new FileNotFoundException("cannot create " + this.publicHTMLDirname + " under " + String.valueOf(this.stageDir));
        }
    }

    protected void buildWebInfDir() throws FileNotFoundException {
        boolean worked;
        this.buildPublicHTMLDir();
        this.webInfDir = new File(this.publicHTMLDir, "WEB-INF/");
        if (!this.webInfDir.exists() && !(worked = this.webInfDir.mkdir())) {
            throw new FileNotFoundException("cannot create WEB-INF/ under " + this.publicHTMLDirname);
        }
    }

    protected void buildWSDLDir() throws FileNotFoundException {
        boolean worked;
        this.buildWebInfDir();
        this.wsdlDir = new File(this.webInfDir, "wsdl/");
        if (!this.wsdlDir.exists() && !(worked = this.wsdlDir.mkdir())) {
            throw new FileNotFoundException("cannot create wsdl/ under WEB-INF/");
        }
    }
}

