/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.ArrayList;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.SQLQueryHandler;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.tools.dbws.BindingModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.ModelWithBuildSql;
import org.eclipse.persistence.tools.dbws.Util;

public class SQLOperationModel
extends ModelWithBuildSql {
    protected String sql;
    protected ArrayList<BindingModel> bindings = new ArrayList();

    @Deprecated
    public String getSQLText() {
        return this.getSql();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Deprecated
    public void setSQLText(String sql) {
        this.setSql(sql);
    }

    public void addBinding(BindingModel binding) {
        this.bindings.add(binding);
    }

    public ArrayList<BindingModel> getBindings() {
        return this.bindings;
    }

    public void setBindings(ArrayList<BindingModel> bindings) {
        this.bindings = bindings;
    }

    @Override
    public boolean isSQLOperation() {
        return true;
    }

    @Override
    public void buildOperation(DBWSBuilder builder) {
        super.buildOperation(builder);
        QueryOperation qo = new QueryOperation();
        qo.setName(this.name);
        SQLQueryHandler sqlqh = new SQLQueryHandler();
        Object result = this.isCollection ? new CollectionResult() : new Result();
        SimpleXMLFormat sxf = null;
        if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
            sxf = new SimpleXMLFormat();
            if (this.simpleXMLFormatTag != null && !this.simpleXMLFormatTag.isEmpty()) {
                sxf.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
        }
        if (this.xmlTag != null && !this.xmlTag.isEmpty()) {
            if (sxf == null) {
                sxf = new SimpleXMLFormat();
                result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            sxf.setXMLTag(this.xmlTag);
        }
        if (sxf != null) {
            result.setSimpleXMLFormat(sxf);
            if (builder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                builder.oxProject.addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
            }
        }
        if (this.binaryAttachment) {
            Attachment attachment = new Attachment();
            attachment.setMimeType("application/octet-stream");
            result.setAttachment(attachment);
        }
        if (this.returnType != null && !this.returnType.isEmpty()) {
            result.setType(Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + this.returnType, builder.schema));
        } else {
            result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            result.setSimpleXMLFormat(sxf == null ? new SimpleXMLFormat() : sxf);
        }
        qo.setResult((Result)result);
        sqlqh.setSqlString(BindingModel.convertJDBCParameterBindingMarkers(this.sql, this.bindings));
        if (!this.bindings.isEmpty()) {
            for (BindingModel param : this.bindings) {
                Parameter p = new Parameter();
                p.setName(param.name);
                p.setType(Util.qNameFromString(param.type, builder.schema));
                qo.getParameters().add(p);
            }
        }
        qo.setQueryHandler((QueryHandler)sqlqh);
        builder.xrServiceModel.getOperations().put(qo.getName(), qo);
        if (Util.requiresSimpleXMLFormat(builder.xrServiceModel) && builder.schema.getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(builder.schema);
        }
    }
}

