/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.net.URL;
import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.EclipseLinkObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.SessionsFactory;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.SessionLoaderException;

public class XRSessionsFactory
extends SessionsFactory {
    static Pattern matchDBWSOrProject = Pattern.compile("eclipselink-db.s-or.xml", 2);
    static Pattern matchDBWSOxProject = Pattern.compile("eclipselink-db.s-ox.xml", 2);

    @Override
    protected Project loadProjectConfig(ProjectConfig projectConfig) {
        Project project = null;
        String projectString = projectConfig.getProjectString();
        if (projectConfig.isProjectClassConfig()) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    project = (Project)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.m_classLoader.loadClass(projectString)));
                }
                project = (Project)PrivilegedAccessHelper.newInstanceFromClass(this.m_classLoader.loadClass(projectString));
            }
            catch (Throwable exception) {
                throw SessionLoaderException.failedToLoadProjectClass(projectString, exception);
            }
        } else {
            try {
                URL url = null;
                Matcher matcher = matchDBWSOrProject.matcher(projectString);
                if (matcher.find()) {
                    String orXml = matcher.group();
                    var7_9 = Util.META_INF_PATHS;
                    var8_10 = var7_9.length;
                    for (var9_12 = 0; var9_12 < var8_10 && (url = this.m_classLoader.getResource(searchPath = (prefix = var7_9[var9_12]) + orXml)) == null; ++var9_12) {
                    }
                } else {
                    matcher = matchDBWSOxProject.matcher(projectString);
                    if (matcher.find()) {
                        String oxXml = matcher.group();
                        var7_9 = Util.META_INF_PATHS;
                        var8_10 = var7_9.length;
                        for (var9_12 = 0; var9_12 < var8_10 && (url = this.m_classLoader.getResource(searchPath = (prefix = var7_9[var9_12]) + oxXml)) == null; ++var9_12) {
                        }
                    }
                }
                if (url != null) {
                    EclipseLinkObjectPersistenceRuntimeXMLProject p = new EclipseLinkObjectPersistenceRuntimeXMLProject();
                    XMLLogin xmlLogin = new XMLLogin();
                    xmlLogin.setDatasourcePlatform(new DOMPlatform());
                    p.setDatasourceLogin(xmlLogin);
                    if (this.m_classLoader != null) {
                        p.getDatasourceLogin().getDatasourcePlatform().getConversionManager().setLoader(this.m_classLoader);
                    }
                    XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                    XMLParser parser = xmlPlatform.newXMLParser();
                    parser.setNamespaceAware(true);
                    parser.setWhitespacePreserving(false);
                    XMLContext context = new XMLContext(p);
                    ((AbstractSession)context.getSession((Class)Project.class)).getEventManager().addListener(new MissingDescriptorListener());
                    XMLUnmarshaller unmarshaller = context.createUnmarshaller();
                    project = (Project)unmarshaller.unmarshal(url);
                }
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() == 7099) {
                    throw SessionLoaderException.failedToLoadProjectXml(projectString, validationException);
                }
                throw SessionLoaderException.failedToParseXML(projectString, validationException);
            }
        }
        return project;
    }
}

