/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.TupleQuery;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaQueryImpl<T>
extends AbstractQueryImpl<T>
implements CriteriaQuery<T> {
    protected SelectionImpl<? extends T> selection;
    protected List<Order> orderBy;
    protected Set<FromImpl> joins;
    private boolean isUnion = false;

    public CriteriaQueryImpl(Metamodel metamodel, AbstractQueryImpl.ResultType queryResult, Class<T> result, CriteriaBuilderImpl queryBuilder) {
        super(metamodel, queryResult, queryBuilder, result);
    }

    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = (SelectionImpl)selection;
        this.selection.findRootAndParameters(this);
        if (selection.isCompoundSelection()) {
            if (this.selection.isCompoundSelection() && ((CompoundSelectionImpl)this.selection).getDuplicateAliasNames() != null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_alias_reused", new Object[]{((CompoundSelectionImpl)this.selection).getDuplicateAliasNames()}));
            }
            if (selection.getJavaType().equals(Tuple.class)) {
                this.queryResult = AbstractQueryImpl.ResultType.TUPLE;
                this.queryType = Tuple.class;
            } else if (((InternalSelection)selection).isConstructor()) {
                Selection[] selectArray = selection.getCompoundSelectionItems().toArray(new Selection[0]);
                this.populateAndSetConstructorSelection((ConstructorSelectionImpl)selection, this.selection.getJavaType(), selectArray);
                this.queryType = selection.getJavaType();
            } else {
                this.queryResult = AbstractQueryImpl.ResultType.OBJECT_ARRAY;
                this.queryType = ClassConstants.AOBJECT;
            }
        } else {
            TypeImpl type;
            Class queryType = selection.getJavaType();
            if (queryType != null) {
                this.queryType = queryType;
            }
            this.queryResult = (type = ((MetamodelImpl)this.metamodel).getType(this.queryType)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY) ? AbstractQueryImpl.ResultType.ENTITY : AbstractQueryImpl.ResultType.OTHER;
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        if (selections == null || selections.length == 0) {
            this.selection = null;
            return this;
        }
        for (Selection<?> select : selections) {
            ((SelectionImpl)select).findRootAndParameters(this);
        }
        if (this.queryResult == AbstractQueryImpl.ResultType.CONSTRUCTOR) {
            this.populateAndSetConstructorSelection(null, this.queryType, selections);
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            if (selections.length == 1 && selections[0].getJavaType().equals(this.queryType)) {
                this.selection = (SelectionImpl)selections[0];
            } else {
                try {
                    this.populateAndSetConstructorSelection(null, this.queryType, selections);
                }
                catch (IllegalArgumentException constructorDoesNotExist) {
                    this.queryResult = AbstractQueryImpl.ResultType.PARTIAL;
                    this.selection = new CompoundSelectionImpl<T>(this.queryType, selections);
                }
            }
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
            this.selection = new CompoundSelectionImpl<T>(this.queryType, selections);
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OTHER)) {
            if (selections.length == 1 && selections[0].getJavaType().equals(this.queryType)) {
                this.selection = (SelectionImpl)selections[0];
            } else {
                if (!BasicTypeHelperImpl.getInstance().isDateClass(this.queryType)) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("MULTIPLE_SELECTIONS_PASSED_TO_QUERY_WITH_PRIMITIVE_RESULT"));
                }
                this.populateAndSetConstructorSelection(null, this.queryType, selections);
            }
        } else {
            this.selection = new CompoundSelectionImpl<T>(this.queryType, selections);
        }
        if (this.selection.isCompoundSelection() && ((CompoundSelectionImpl)this.selection).getDuplicateAliasNames() != null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_alias_reused", new Object[]{((CompoundSelectionImpl)this.selection).getDuplicateAliasNames()}));
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        if (selectionList == null) {
            this.selection = null;
            return this;
        }
        return this.multiselect(selectionList.toArray(new Selection[0]));
    }

    @Override
    public CriteriaQuery<T> where(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        return (CriteriaQuery)super.where(restriction);
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... restrictions) {
        return (CriteriaQuery)super.where(restrictions);
    }

    @Override
    public CriteriaQuery<T> where(List<Predicate> restrictions) {
        return (CriteriaQuery)super.where(restrictions);
    }

    @Override
    public CriteriaQuery<T> groupBy(jakarta.persistence.criteria.Expression<?> ... grouping) {
        super.groupBy(grouping);
        return this;
    }

    @Override
    public CriteriaQuery<T> groupBy(List<jakarta.persistence.criteria.Expression<?>> grouping) {
        super.groupBy(grouping);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        super.having(restriction);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... restrictions) {
        super.having(restrictions);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(List<Predicate> restrictions) {
        super.having(restrictions);
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... o) {
        this.orderBy = new ArrayList<Order>();
        for (Order order : o) {
            this.findRootAndParameters(order);
            this.orderBy.add(order);
        }
        return this;
    }

    public CriteriaQuery<T> orderBy(List<Order> o) {
        for (Order order : o) {
            this.findRootAndParameters(order);
        }
        this.orderBy = o;
        return this;
    }

    public void populateAndSetConstructorSelection(ConstructorSelectionImpl<T> constructorSelection, Class<T> class1, Selection<?> ... selections) throws IllegalArgumentException {
        Class[] constructorArgs = new Class[selections.length];
        int count = 0;
        for (Selection<?> select : selections) {
            if (select instanceof ConstructorSelectionImpl) {
                ConstructorSelectionImpl constructorSelect = (ConstructorSelectionImpl)select;
                Selection[] selectArray = constructorSelect.getCompoundSelectionItems().toArray(new Selection[0]);
                this.populateAndSetConstructorSelection(constructorSelect, constructorSelect.getJavaType(), selectArray);
            }
            constructorArgs[count++] = select.getJavaType();
        }
        Constructor constructor = null;
        try {
            constructor = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor<T>(class1, constructorArgs, false)) : PrivilegedAccessHelper.getConstructorFor(class1, constructorArgs, false);
            if (constructorSelection == null) {
                constructorSelection = new ConstructorSelectionImpl<T>(class1, selections);
            }
            this.queryResult = AbstractQueryImpl.ResultType.CONSTRUCTOR;
            constructorSelection.setConstructor(constructor);
            constructorSelection.setConstructorArgTypes(constructorArgs);
            this.selection = constructorSelection;
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.queryType};
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("criteria_no_constructor_found", params), e);
        }
    }

    @Override
    public CriteriaQuery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public void addJoin(FromImpl from) {
        if (this.joins == null) {
            this.joins = new LinkedHashSet<FromImpl>();
        }
        this.joins.add(from);
    }

    protected ReadAllQuery getDatabaseQuery(boolean toReportQuery) {
        ReadAllQuery query = null;
        query = this.selection == null || !this.selection.isCompoundSelection() ? this.createSimpleQuery(toReportQuery) : this.createCompoundQuery(toReportQuery);
        return query;
    }

    @Override
    protected DatabaseQuery getDatabaseQuery() {
        return this.getDatabaseQuery(false);
    }

    public List<Order> getOrderList() {
        return this.orderBy;
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    protected ReadAllQuery createCompoundQuery(boolean toReportQuery) {
        ReadAllQuery query = null;
        if (this.queryResult == AbstractQueryImpl.ResultType.UNKNOWN) {
            this.queryResult = this.selection.isConstructor() ? AbstractQueryImpl.ResultType.CONSTRUCTOR : (this.selection.getJavaType().equals(Tuple.class) ? AbstractQueryImpl.ResultType.TUPLE : AbstractQueryImpl.ResultType.OBJECT_ARRAY);
        }
        if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.PARTIAL)) {
            ReadAllQuery raq;
            List<Selection<?>> selectionItems = this.selection.getCompoundSelectionItems();
            if (toReportQuery) {
                raq = CriteriaQueryImpl.createReportQuery(this.queryType);
                for (SelectionImpl selectionImpl : selectionItems) {
                    ((ReportQuery)raq).addAttribute(selectionImpl.getAlias(), selectionImpl.getCurrentNode(), selectionImpl.getJavaType());
                }
            } else {
                raq = new ReadAllQuery(this.queryType);
            }
            raq.dontMaintainCache();
            for (SelectionImpl selectionImpl : selectionItems) {
                raq.addPartialAttribute(selectionImpl.currentNode);
            }
            raq.setExpressionBuilder(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder());
            query = raq;
        } else {
            ReportQuery reportQuery = null;
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.CONSTRUCTOR) || this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OTHER)) {
                reportQuery = new ReportQuery();
                reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)this.selection).translate());
                reportQuery.setShouldReturnSingleAttribute(true);
            } else {
                if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                    reportQuery = new TupleQuery(this.selection == null ? new ArrayList() : this.selection.getCompoundSelectionItems());
                } else {
                    reportQuery = new ReportQuery();
                    reportQuery.setShouldReturnWithoutReportQueryResult(true);
                }
                reportQuery.setExpressionBuilder(((InternalSelection)this.selection.getCompoundSelectionItems().get(0)).getCurrentNode().getBuilder());
                for (Selection<?> nested : this.selection.getCompoundSelectionItems()) {
                    if (((SelectionImpl)nested).isConstructor()) {
                        reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)nested).translate());
                        continue;
                    }
                    if (nested.isCompoundSelection()) {
                        throw new IllegalStateException(ExceptionLocalization.buildMessage("NESTED_COMPOUND_SELECTION_OTHER_THAN_CONSTRUCTOR_NOT_SUPPORTED"));
                    }
                    if (((InternalSelection)nested).isFrom()) {
                        reportQuery.addItem(nested.getAlias(), ((SelectionImpl)nested).getCurrentNode(), ((FromImpl)nested).findJoinFetches());
                        continue;
                    }
                    if (((InternalExpression)nested).isCompoundExpression() && ((FunctionExpressionImpl)nested).getOperation() == "size") {
                        PathImpl pathImpl = (PathImpl)((FunctionExpressionImpl)nested).getChildExpressions().get(0);
                        ExpressionImpl fromExpression = (ExpressionImpl)pathImpl.getParentPath();
                        reportQuery.addAttribute(nested.getAlias(), pathImpl.getCurrentNode().count(), CoreClassConstants.INTEGER);
                        reportQuery.addGrouping(fromExpression.getCurrentNode());
                        continue;
                    }
                    reportQuery.addAttribute(nested.getAlias(), ((SelectionImpl)nested).getCurrentNode(), nested.getJavaType());
                }
            }
            ExpressionBuilder builder = null;
            Class<?> queryClazz = null;
            if (this.where != null && ((InternalSelection)this.where).getCurrentNode() != null) {
                builder = ((InternalSelection)this.where).getCurrentNode().getBuilder();
                queryClazz = builder.getQueryClass();
            }
            if (queryClazz == null && this.selection != null) {
                for (Selection<?> s : this.selection.getCompoundSelectionItems()) {
                    if (((InternalSelection)s).getCurrentNode() != null && (queryClazz = (builder = ((InternalSelection)s).getCurrentNode().getBuilder()).getQueryClass()) != null) break;
                }
            }
            if (queryClazz == null && this.roots != null) {
                Root r;
                Iterator iterator = this.roots.iterator();
                while (iterator.hasNext() && (((RootImpl)(r = (Root)iterator.next())).getCurrentNode() == null || (queryClazz = (builder = ((RootImpl)r).getCurrentNode().getBuilder()).getQueryClass()) == null)) {
                }
            }
            reportQuery.setExpressionBuilder(builder);
            reportQuery.setReferenceClass(queryClazz);
            query = reportQuery;
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                for (jakarta.persistence.criteria.Expression exp : this.groupBy) {
                    reportQuery.addGrouping(((InternalSelection)exp).getCurrentNode());
                }
            }
            if (this.havingClause != null) {
                reportQuery.setHavingExpression(((InternalSelection)this.havingClause).getCurrentNode());
            }
        }
        return query;
    }

    protected ReadAllQuery createSimpleQuery(boolean toReportQuery) {
        ObjectLevelReadQuery query = null;
        if (this.queryResult == AbstractQueryImpl.ResultType.UNKNOWN) {
            if (this.selection == null) {
                if (this.roots != null && !this.roots.isEmpty()) {
                    this.selection = (SelectionImpl)this.roots.iterator().next();
                    query = toReportQuery ? this.createReportQueryWithItem(((FromImpl)this.selection).getJavaType()) : new ReadAllQuery(((FromImpl)this.selection).getJavaType());
                    List<Expression> list = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    for (Expression expression : list) {
                        query.addJoinedAttribute(expression);
                    }
                    if (!list.isEmpty()) {
                        query.setExpressionBuilder(list.get(0).getBuilder());
                    }
                } else if (this.roots == null || this.roots.isEmpty()) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("CRITERIA_NO_ROOT_FOR_COMPOUND_QUERY"));
                }
            } else {
                TypeImpl<? extends T> type = ((MetamodelImpl)this.metamodel).getType(this.selection.getJavaType());
                if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                    if (toReportQuery) {
                        query = this.createReportQueryWithItem(type.getJavaType());
                        ((ReportQuery)query).setShouldReturnWithoutReportQueryResult(true);
                    } else {
                        query = new ReadAllQuery(type.getJavaType());
                    }
                    List<Expression> list = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    for (Expression fetch : list) {
                        query.addJoinedAttribute(fetch);
                    }
                    query.setExpressionBuilder(this.selection.getCurrentNode().getBuilder());
                } else {
                    query = this.createReportQueryWithSelection(this.selection.getCurrentNode().getBuilder().getQueryClass());
                }
            }
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            boolean nonRootSelection;
            boolean bl = nonRootSelection = this.selection != null && !this.selection.isRoot();
            if (nonRootSelection) {
                query = this.createReportQueryWithItem(this.queryType);
                ((ReportQuery)query).setShouldReturnSingleAttribute(true);
            } else if (toReportQuery) {
                query = this.createReportQueryWithItem(this.queryType);
                ((ReportQuery)query).setShouldReturnWithoutReportQueryResult(true);
            } else {
                query = new ReadAllQuery(this.queryType);
            }
            if (!nonRootSelection || this.isUnion) {
                boolean doSetExpressionBuilder = true;
                if (this.roots != null && !this.roots.isEmpty()) {
                    List<Expression> list = ((FromImpl)this.roots.iterator().next()).findJoinFetches();
                    if (!list.isEmpty()) {
                        query.setExpressionBuilder(list.get(0).getBuilder());
                        doSetExpressionBuilder = false;
                    }
                    if (this.selection == null || this.selection.isRoot()) {
                        for (Expression fetch : list) {
                            query.addJoinedAttribute(fetch);
                        }
                    }
                }
                if (doSetExpressionBuilder && this.selection != null) {
                    query.setExpressionBuilder(this.selection.currentNode.getBuilder());
                }
            }
        } else {
            ReportQuery reportQuery = null;
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                ArrayList<SelectionImpl<? extends T>> list = new ArrayList<SelectionImpl<? extends T>>();
                list.add(this.selection);
                reportQuery = new TupleQuery(list);
            } else {
                reportQuery = new ReportQuery();
                reportQuery.setShouldReturnWithoutReportQueryResult(true);
            }
            if (this.selection != null) {
                if (!this.selection.isCompoundSelection() && ((InternalExpression)((Object)this.selection)).isCompoundExpression()) {
                    if (((FunctionExpressionImpl)this.selection).getOperation() == "size") {
                        PathImpl collectionExpression = (PathImpl)((FunctionExpressionImpl)this.selection).getChildExpressions().get(0);
                        ExpressionImpl expressionImpl = (ExpressionImpl)collectionExpression.getParentPath();
                        reportQuery.addAttribute(this.selection.getAlias(), collectionExpression.getCurrentNode().count(), CoreClassConstants.INTEGER);
                        reportQuery.addGrouping(expressionImpl.getCurrentNode());
                    } else {
                        reportQuery.addAttribute(this.selection.getAlias(), this.selection.getCurrentNode(), this.selection.getJavaType());
                    }
                } else if (this.selection.isFrom()) {
                    reportQuery.addItem(this.selection.getAlias(), this.selection.getCurrentNode(), ((FromImpl)this.selection).findJoinFetches());
                } else {
                    reportQuery.addAttribute(this.selection.getAlias(), this.selection.getCurrentNode(), this.selection.getJavaType());
                }
                reportQuery.setReferenceClass(this.selection.getCurrentNode().getBuilder().getQueryClass());
                reportQuery.setExpressionBuilder(this.selection.getCurrentNode().getBuilder());
            }
            query = reportQuery;
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                for (jakarta.persistence.criteria.Expression expression : this.groupBy) {
                    reportQuery.addGrouping(((InternalSelection)expression).getCurrentNode());
                }
            }
            if (this.havingClause != null) {
                reportQuery.setHavingExpression(((InternalSelection)this.havingClause).getCurrentNode());
            }
        }
        if (query.getReferenceClass() == null) {
            if (this.where != null && ((InternalSelection)this.where).getCurrentNode() != null && ((InternalSelection)this.where).getCurrentNode().getBuilder() != null && ((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass() != null) {
                query.setReferenceClass(((InternalSelection)this.where).getCurrentNode().getBuilder().getQueryClass());
            } else if (this.roots != null && !this.roots.isEmpty()) {
                Root<?> root = this.getRoots().iterator().next();
                query.setReferenceClass(root.getJavaType());
            }
        }
        if (this.selection == null && this.roots != null && !this.roots.isEmpty()) {
            for (Root<?> root : this.getRoots()) {
                if (!root.getJavaType().equals(this.queryType)) continue;
                query.setExpressionBuilder(((RootImpl)root).getCurrentNode().getBuilder());
                break;
            }
        }
        return query;
    }

    private static ReportQuery createReportQuery(Class<?> classToRead) {
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(classToRead);
        return query;
    }

    private ReportQuery createReportQueryWithItem(Class<?> classToRead) {
        ReportQuery query = CriteriaQueryImpl.createReportQuery(classToRead);
        if (this.selection != null) {
            if (this.selection.isFrom()) {
                query.addItem(this.selection.getAlias(), this.selection.getCurrentNode(), ((FromImpl)this.selection).findJoinFetches());
            } else {
                query.addAttribute(this.selection.getAlias(), this.selection.getCurrentNode(), this.selection.getJavaType());
            }
        } else {
            FromImpl root = (FromImpl)this.roots.iterator().next();
            query.addItem(root.getAlias(), root.getCurrentNode());
        }
        return query;
    }

    private ReportQuery createReportQueryWithSelection(Class<?> classToRead) {
        ReportQuery query = CriteriaQueryImpl.createReportQuery(classToRead);
        if (this.selection == null) {
            throw new IllegalStateException("Called createReportQueryWithSelection with no selection set");
        }
        if (!this.selection.isCompoundSelection() && ((InternalExpression)((Object)this.selection)).isCompoundExpression()) {
            if (((FunctionExpressionImpl)this.selection).getOperation() == "size") {
                PathImpl collectionExpression = (PathImpl)((FunctionExpressionImpl)this.selection).getChildExpressions().get(0);
                ExpressionImpl fromExpression = (ExpressionImpl)collectionExpression.getParentPath();
                query.addAttribute(this.selection.getAlias(), collectionExpression.getCurrentNode().count(), CoreClassConstants.INTEGER);
                query.addGrouping(fromExpression.getCurrentNode());
            }
            query.addAttribute(this.selection.getAlias(), this.selection.getCurrentNode(), this.selection.getJavaType());
        } else {
            query.addItem(this.selection.getAlias(), this.selection.getCurrentNode());
            query.setShouldReturnSingleAttribute(true);
        }
        return query;
    }

    @Override
    public DatabaseQuery translate() {
        return this.translate(false);
    }

    public ReportQuery transalteToReportQuery() {
        return (ReportQuery)this.translate(true);
    }

    private ReadAllQuery translate(boolean toReportQuery) {
        ReadAllQuery query = (ReadAllQuery)this.translate(this.getDatabaseQuery(toReportQuery));
        Iterator<Root<?>> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)iterator.next());
        }
        if (this.joins != null && !this.joins.isEmpty()) {
            for (FromImpl join : this.joins) {
                query.addNonFetchJoinedAttribute(join.getCurrentNode());
            }
        }
        if (this.distinct) {
            query.setDistinctState((short)1);
        } else {
            query.setDistinctState((short)2);
            if (query.hasJoining()) {
                query.setShouldFilterDuplicates(false);
            }
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            for (Order order : this.orderBy) {
                OrderImpl orderImpl = (OrderImpl)order;
                Expression orderExp = ((ExpressionImpl)orderImpl.getExpression()).getCurrentNode();
                orderExp = orderImpl.isAscending() ? orderExp.ascending() : orderExp.descending();
                orderExp = switch (orderImpl.getNullPrecedence()) {
                    case Nulls.FIRST -> orderExp.nullsFirst();
                    case Nulls.LAST -> orderExp.nullsLast();
                    default -> orderExp;
                };
                query.addOrdering(orderExp);
            }
        }
        return query;
    }

    void isUnion() {
        this.isUnion = true;
    }
}

