/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sdo.SDOException;
import org.eclipse.persistence.sessions.Session;

public class InstanceClassConverter
implements Converter {
    private Class<?> customClass;

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (objectValue != null) {
            return objectValue.toString();
        }
        return null;
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        if (dataValue != null) {
            Class[] params = new Class[]{String.class};
            Constructor ctor = null;
            try {
                ctor = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetDeclaredConstructorFor(this.customClass, params, true)) : PrivilegedAccessHelper.getDeclaredConstructorFor(this.customClass, params, true);
                Object[] args = new Object[]{dataValue.toString()};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(ctor, args));
                }
                return PrivilegedAccessHelper.invokeConstructor(ctor, args);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PrivilegedActionException e) {
                throw SDOException.noConstructorWithString(e, this.customClass.getName());
            }
        }
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
    }

    public void setCustomClass(Class<?> customClass) {
        this.customClass = customClass;
    }

    public Class<?> getCustomClass() {
        return this.customClass;
    }
}

