/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import jakarta.ws.rs.core.MediaType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.persistence.internal.jpa.rs.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.MethodExitLogData;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class JPARSLogger {
    public static final JPARSLogger DEFAULT_LOGGER = new JPARSLogger(AbstractSessionLog.getLog());
    private SessionLog sessionLog;

    public JPARSLogger(SessionLog sessionLog) {
        this.sessionLog = sessionLog;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = sessionLog;
    }

    public void entering(String sourceClass, String sourceMethod, String sessionId, Object[] params) {
        if (this.isLoggableFinest()) {
            SessionLogEntry sle = new SessionLogEntry(1, "jpars", sessionId, "ENTRY {0}", this.getParamsWithAdditionalInfo(params), null, false);
            sle.setSourceClassName(sourceClass);
            sle.setSourceMethodName(sourceMethod);
            this.sessionLog.log(sle);
        }
    }

    public void entering(String sourceClass, String sourceMethod, String sessionId, InputStream in) {
        if (this.isLoggableFinest() && in.markSupported()) {
            try {
                String data = this.readData(in);
                in.reset();
                if (data != null) {
                    Object[] logParams = this.getParamsWithAdditionalInfo(new Object[]{data});
                    SessionLogEntry sle = new SessionLogEntry(1, "jpars", sessionId, "ENTRY {0}", logParams, null, false);
                    sle.setSourceClassName(sourceClass);
                    sle.setSourceMethodName(sourceMethod);
                    this.sessionLog.log(sle);
                }
            }
            catch (Throwable throwable) {
                this.exception(sessionId, throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public void exiting(String sourceClass, String sourceMethod, String sessionId, Object[] params) {
        if (this.isLoggableFinest()) {
            try {
                Object[] logParams = new Object[]{new MethodExitLogData(this.getParamsWithAdditionalInfo(params))};
                SessionLogEntry sle = new SessionLogEntry(1, "jpars", sessionId, "RETURN {0}", logParams, null, false);
                sle.setSourceClassName(sourceClass);
                sle.setSourceMethodName(sourceMethod);
                this.sessionLog.log(sle);
            }
            catch (Throwable throwable) {
                this.exception(sessionId, throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public void exiting(String sourceClass, String sourceMethod, String sessionId, PersistenceContext context, Object object, MediaType mediaType) {
        if (this.isLoggableFinest() && context != null && object != null && mediaType != null) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                context.marshall(object, mediaType, outputStream, true);
                if (object instanceof PersistenceWeavedRest) {
                    this.exiting(sourceClass, sourceMethod, sessionId, new Object[]{object.getClass().getName(), outputStream.toString(StandardCharsets.UTF_8)});
                } else {
                    this.exiting(sourceClass, sourceMethod, sessionId, new Object[]{outputStream.toString(StandardCharsets.UTF_8)});
                }
            }
            catch (Throwable throwable) {
                this.exception(sessionId, throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public void finest(String sessionId, String message, Object[] params) {
        this.log(1, sessionId, message, this.getParamsWithAdditionalInfo(params));
    }

    public void fine(String sessionId, String message, Object[] params) {
        this.log(3, sessionId, message, this.getParamsWithAdditionalInfo(params));
    }

    public void warning(String sessionId, String message, Object[] params) {
        this.log(6, sessionId, message, this.getParamsWithAdditionalInfo(params));
    }

    public void error(String sessionId, String message, Object[] params) {
        this.log(7, sessionId, message, this.getParamsWithAdditionalInfo(params));
    }

    public void exception(String sessionId, String message, Object[] params, Throwable exc) {
        this.log(7, sessionId, message, this.getParamsWithAdditionalInfo(params), exc);
    }

    public void setLogLevel(int level) {
        this.sessionLog.setLevel(level, "jpars");
    }

    public boolean isLoggableFinest() {
        return this.sessionLog.shouldLog(1, "jpars");
    }

    private Object[] getParamsWithAdditionalInfo(Object[] params) {
        String requestId = (String)DataStorage.get("requestId");
        if (params != null) {
            Object[] paramsWithRequestId = new Object[params.length + 1];
            paramsWithRequestId[0] = requestId;
            System.arraycopy(params, 0, paramsWithRequestId, 1, params.length);
            return paramsWithRequestId;
        }
        return new Object[]{requestId};
    }

    private void log(int level, String sessionId, String message, Object[] params) {
        this.log(level, sessionId, message, params, null);
    }

    private void log(int level, String sessionId, String message, Object[] params, Throwable t) {
        Objects.requireNonNull(this.sessionLog);
        if (this.sessionLog.shouldLog(level, "jpars")) {
            SessionLogEntry sle = new SessionLogEntry(level, "jpars", sessionId, LoggingLocalization.buildMessage(message, params), t);
            sle.setParameters(params);
            this.sessionLog.log(sle);
        }
    }

    private String readData(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream bais = null;
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] bytes = buffer.toByteArray();
        bais = new ByteArrayInputStream(bytes);
        return JPARSLogger.getDataFromInputStream(bais);
    }

    private static String getDataFromInputStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

