/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRClassWriter;

public class XRDynamicClassLoader
extends DynamicClassLoader {
    public static final String COLLECTION_WRAPPER_SUFFIX = "_CollectionWrapper";
    private Boolean generateSubclasses = Boolean.TRUE;

    public XRDynamicClassLoader(ClassLoader parentLoader) {
        super(parentLoader, new XRClassWriter());
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        if (!this.generateSubclasses.booleanValue()) {
            throw new ClassNotFoundException(className);
        }
        try {
            byte[] data = this.defaultWriter.writeClass(this, className);
            return this.defineClass(className, data, 0, data.length);
        }
        catch (ClassCircularityError | ClassFormatError cfe) {
            throw new ClassNotFoundException(className, cfe);
        }
    }

    public void dontGenerateSubclasses() {
        this.generateSubclasses = Boolean.TRUE;
    }
}

