/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;

public final class ConstructorQueryMappings {
    private String className;
    private List<DatabaseMapping> mappings;
    private DatabaseQuery query;

    ConstructorQueryMappings(DatabaseQuery query) {
        this.query = query;
        this.mappings = new LinkedList<DatabaseMapping>();
    }

    public String getClassName() {
        return this.className;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public boolean isConstructorQuery() {
        return this.className != null;
    }

    public Iterable<DatabaseMapping> mappings() {
        if (this.mappings.isEmpty()) {
            return Collections.emptyList();
        }
        return new LinkedList<DatabaseMapping>(this.mappings);
    }

    void populate(JPQLGrammar jpqlGrammar) {
        JPQLQueryContext queryContext = new JPQLQueryContext(this.query, jpqlGrammar);
        ConstructorVisitor visitor = new ConstructorVisitor(queryContext);
        queryContext.getJPQLExpression().accept(visitor);
    }

    private class ConstructorVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private final JPQLQueryContext queryContext;

        ConstructorVisitor(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        @Override
        public void visit(ConstructorExpression expression) {
            ConstructorQueryMappings.this.className = expression.getClassName();
            ConstructorItemVisitor visitor = new ConstructorItemVisitor(this.queryContext);
            expression.getConstructorItems().accept(visitor);
        }

        @Override
        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        @Override
        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SelectStatement expression) {
            expression.getSelectClause().accept(this);
        }
    }

    private class ConstructorItemVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private final JPQLQueryContext queryContext;

        ConstructorItemVisitor(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.visitPathExpression(expression);
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            this.visitPathExpression(expression);
        }

        private void visitPathExpression(AbstractPathExpression expression) {
            DatabaseMapping mapping = this.queryContext.resolveMapping(expression);
            if (mapping != null) {
                ConstructorQueryMappings.this.mappings.add(mapping);
            }
        }
    }
}

