/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBException;

public class AccessorFactoryWrapper {
    private static final String ACCESSOR_FACTORY_CREATE_FIELD_ACCESSOR = "createFieldAccessor";
    private static final String ACCESSOR_FACTORY_CREATE_PROPERTY_ACCESSOR = "createPropertyAccessor";
    private Object accessorFactory;
    private Method createFieldAccessorMethod;
    private Method createPropertyAccessorMethod;

    public AccessorFactoryWrapper(Object factory) {
        this.accessorFactory = factory;
        Class<?> accessorClass = factory.getClass();
        try {
            this.createPropertyAccessorMethod = PrivilegedAccessHelper.getDeclaredMethod(accessorClass, ACCESSOR_FACTORY_CREATE_PROPERTY_ACCESSOR, new Class[]{Class.class, Method.class, Method.class});
            this.createFieldAccessorMethod = PrivilegedAccessHelper.getDeclaredMethod(accessorClass, ACCESSOR_FACTORY_CREATE_FIELD_ACCESSOR, new Class[]{Class.class, Field.class, Boolean.TYPE});
        }
        catch (Exception ex) {
            throw JAXBException.invalidAccessorFactory(accessorClass, ex);
        }
    }

    public Object createFieldAccessor(Class<?> beanClass, Field field, boolean isReadOnly) {
        try {
            return PrivilegedAccessHelper.invokeMethod(this.createFieldAccessorMethod, this.accessorFactory, new Object[]{beanClass, field, isReadOnly});
        }
        catch (Exception ex) {
            throw JAXBException.errorCreatingFieldAccessor(this.accessorFactory, ex);
        }
    }

    public Object createPropertyAccessor(Class<?> beanClass, Method getMethod, Method setMethod) {
        try {
            return PrivilegedAccessHelper.invokeMethod(this.createPropertyAccessorMethod, this.accessorFactory, new Object[]{beanClass, getMethod, setMethod});
        }
        catch (Exception ex) {
            throw JAXBException.errorCreatingPropertyAccessor(this.accessorFactory, ex);
        }
    }
}

