/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class ValuesAccessor
extends AttributeAccessor {
    protected DatabaseMapping mapping;

    public ValuesAccessor(DatabaseMapping mapping) {
        this.mapping = mapping;
        this.setAttributeName(mapping.getAttributeName());
    }

    @Override
    public boolean isValuesAccessor() {
        return true;
    }

    @Override
    public Object getAttributeValueFromObject(Object entity) throws DescriptorException {
        Map<String, DynamicEntityImpl.PropertyWrapper> propertiesMap = ((DynamicEntityImpl)entity).getPropertiesMap();
        DynamicEntityImpl.PropertyWrapper wrapper = propertiesMap.get(this.attributeName);
        return wrapper.getValue();
    }

    @Override
    public void setAttributeValueInObject(Object entity, Object value) throws DescriptorException {
        Map<String, DynamicEntityImpl.PropertyWrapper> propertiesMap = ((DynamicEntityImpl)entity).getPropertiesMap();
        DynamicEntityImpl.PropertyWrapper wrapper = propertiesMap.get(this.attributeName);
        wrapper.setValue(value);
        wrapper.isSet(true);
    }

    @Override
    public Class<?> getAttributeClass() {
        if (this.mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)this.mapping;
            if (refMapping.isCollectionMapping()) {
                return refMapping.getContainerPolicy().getContainerClass();
            }
            if (refMapping.usesIndirection()) {
                return ValueHolderInterface.class;
            }
            return refMapping.getReferenceClass();
        }
        if (this.mapping.getAttributeClassification() == null) {
            return CoreClassConstants.OBJECT;
        }
        return this.mapping.getAttributeClassification();
    }
}

