/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class MethodDefinition
extends CodeDefinition {
    protected boolean isAbstract;
    protected boolean isConstructor = false;
    protected String returnType = "void";
    protected List<String> argumentNames;
    protected List<String> lines = new ArrayList<String>();
    protected List<String> exceptions = new ArrayList<String>();
    protected StringBuilder storedBuffer = new StringBuilder();

    protected MethodDefinition() {
    }

    public void addException(String exceptionTypeName) {
        this.exceptions.add(exceptionTypeName);
    }

    public void addLine(String line) {
        this.storedBuffer.append(line);
        this.getLines().add(this.storedBuffer.toString());
        this.storedBuffer = new StringBuilder();
    }

    public void addToBuffer(String partOfLine) {
        this.storedBuffer.append(partOfLine);
    }

    private void adjustExceptions(Map<String, Set<String>> typeNameMap) {
        for (String exceptionName : new ArrayList<String>(this.getExceptions())) {
            String adjustedExceptionName;
            if (exceptionName.equals(adjustedExceptionName = MethodDefinition.adjustTypeName(exceptionName, typeNameMap))) continue;
            this.replaceException(exceptionName, adjustedExceptionName);
        }
    }

    private void adjustLine(String line, Map<String, Set<String>> typeNameMap) {
        StringBuilder lineInProgress = new StringBuilder(line);
        Set<String> typeNames = MethodDefinition.parseForTypeNames(lineInProgress.toString());
        for (String typeName : typeNames) {
            String adjustedTypeName;
            if (typeName.equals(adjustedTypeName = MethodDefinition.adjustTypeName(typeName, typeNameMap))) continue;
            int typeNameStartIndex = lineInProgress.toString().indexOf(typeName);
            while (typeNameStartIndex != -1) {
                lineInProgress.replace(typeNameStartIndex, typeNameStartIndex + typeName.length(), adjustedTypeName);
                typeNameStartIndex = lineInProgress.toString().indexOf(typeName);
            }
        }
        this.replaceLine(line, lineInProgress.toString());
    }

    private void adjustLines(Map<String, Set<String>> typeNameMap) {
        for (String s : new ArrayList<String>(this.getLines())) {
            this.adjustLine(s, typeNameMap);
        }
    }

    private void adjustReturnType(Map<String, Set<String>> typeNameMap) {
        String adjustedReturnType = MethodDefinition.adjustTypeName(this.getReturnType(), typeNameMap);
        if (!this.getReturnType().equals(adjustedReturnType)) {
            this.setReturnType(adjustedReturnType);
        }
    }

    protected void adjustTypeNames(Map<String, Set<String>> typeNameMap) {
        this.adjustReturnType(typeNameMap);
        this.adjustExceptions(typeNameMap);
        this.adjustLines(typeNameMap);
    }

    protected abstract boolean argumentsEqual(MethodDefinition var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodDefinition)) {
            return false;
        }
        MethodDefinition methodDefinition = (MethodDefinition)object;
        if (this.name == null && methodDefinition.getName() != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(methodDefinition.getName())) {
            return false;
        }
        if (!this.accessLevel.equals(methodDefinition.getAccessLevel())) {
            return false;
        }
        if (!this.returnType.equals(methodDefinition.getReturnType())) {
            return false;
        }
        if (!this.argumentsEqual(methodDefinition)) {
            return false;
        }
        return this.exceptionsEqual(methodDefinition);
    }

    protected boolean exceptionsEqual(MethodDefinition methodDefinition) {
        Object[] exceptions2;
        Object[] exceptions1 = this.getExceptions().toArray();
        if (exceptions1.length == (exceptions2 = methodDefinition.getExceptions().toArray()).length) {
            for (int i = 0; i < exceptions1.length; ++i) {
                if ((exceptions1[i] != null || exceptions1[i] == exceptions2[i]) && exceptions1[i].equals(exceptions2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new ArrayList<String>(5);
        }
        return this.argumentNames;
    }

    public String getArgumentName(int index) {
        return this.getArgumentNames().get(index);
    }

    public Iterator<String> argumentNames() {
        return this.getArgumentNames().iterator();
    }

    public int argumentNamesSize() {
        return this.getArgumentNames().size();
    }

    protected abstract List<String> getArgumentTypeNames();

    protected abstract List<String> getArgumentTypes();

    public List<String> getLines() {
        return this.lines;
    }

    protected List<String> getExceptions() {
        return this.exceptions;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int hash = this.accessLevel.hashCode();
        hash ^= this.returnType.hashCode();
        hash ^= this.getArgumentTypes().hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        return hash ^= this.getExceptions().hashCode();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    protected void putTypeNamesInMap(Map<String, Set<String>> typeNameMap) {
        MethodDefinition.putTypeNameInMap(this.getReturnType(), typeNameMap);
        for (String string : this.getExceptions()) {
            MethodDefinition.putTypeNameInMap(string, typeNameMap);
        }
        for (String s : this.getArgumentTypeNames()) {
            MethodDefinition.putTypeNameInMap(s, typeNameMap);
        }
    }

    protected void replaceException(String oldExceptionName, String newExceptionName) {
        int index = this.getExceptions().indexOf(oldExceptionName);
        this.getExceptions().remove(oldExceptionName);
        this.getExceptions().add(index, newExceptionName);
    }

    protected void replaceLine(String oldLine, String newLine) {
        int index = this.getLines().indexOf(oldLine);
        this.getLines().remove(oldLine);
        this.getLines().add(index, newLine);
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public void writeBody(CodeGenerator generator) throws IOException {
        if (!this.isConstructor()) {
            generator.writeType(this.getReturnType());
            generator.write(" ");
        }
        generator.write(this.getName());
        generator.write("(");
        this.writeArguments(generator);
        generator.write(")");
        if (!this.exceptions.isEmpty()) {
            this.writeThrowsClause(generator);
        }
        if (this.isAbstract()) {
            generator.write(";");
        } else {
            generator.write(" {");
            generator.cr();
            for (String s : this.getLines()) {
                generator.tab();
                generator.writeln(s);
            }
            generator.write("}");
        }
    }

    protected abstract void writeArguments(CodeGenerator var1) throws IOException;

    protected void writeThrowsClause(CodeGenerator generator) throws IOException {
        generator.write(" throws ");
        Iterator<String> exceptionIterator = this.exceptions.iterator();
        while (exceptionIterator.hasNext()) {
            generator.write(exceptionIterator.next());
            if (!exceptionIterator.hasNext()) continue;
            generator.write(", ");
        }
    }
}

