/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.converters.CoreConverter;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.jaxb.GenericsClassHelper;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverterAdapter;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLJavaTypeConverter
extends XMLConverterAdapter {
    protected Class<?> boundType = Object.class;
    protected Class<?> valueType = Object.class;
    protected Class<? extends XmlAdapter<?, ?>> xmlAdapterClass;
    protected String xmlAdapterClassName;
    protected XmlAdapter<?, ?> xmlAdapter;
    protected QName schemaType;
    protected DatabaseMapping mapping;
    protected CoreConverter<DatabaseMapping, Session> nestedConverter;

    public XMLJavaTypeConverter() {
    }

    public XMLJavaTypeConverter(Class<?> xmlAdapterClass) {
        this.setXmlAdapterClass(xmlAdapterClass);
    }

    public XMLJavaTypeConverter(String xmlAdapterClassName) {
        this.xmlAdapterClassName = xmlAdapterClassName;
    }

    public XMLJavaTypeConverter(Class<?> xmlAdapterClass, QName schemaType) {
        this.setSchemaType(schemaType);
        this.setXmlAdapterClass(xmlAdapterClass);
    }

    public XMLJavaTypeConverter(String xmlAdapterClassName, QName schemaType) {
        this.setSchemaType(schemaType);
        this.setXmlAdapterClassName(xmlAdapterClassName);
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        try {
            XmlAdapter runtimeAdapter;
            HashMap adapters;
            XmlAdapter adapter = this.xmlAdapter;
            if (unmarshaller != null && (adapters = (HashMap)unmarshaller.getProperty("xml-javatype-adapters")) != null && (runtimeAdapter = (XmlAdapter)adapters.get(this.xmlAdapterClass)) != null) {
                adapter = runtimeAdapter;
            }
            Object toConvert = dataValue;
            if (this.nestedConverter != null) {
                toConvert = this.nestedConverter.convertDataValueToObjectValue(toConvert, session);
            } else if (dataValue != null && dataValue.getClass() != this.valueType) {
                toConvert = this.mapping instanceof BinaryDataMapping ? XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(dataValue, this.valueType, (AbstractSession)session, this.mapping.getContainerPolicy()) : (this.getSchemaType() != null ? ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(dataValue, this.valueType, this.getSchemaType()) : session.getDatasourcePlatform().getConversionManager().convertObject(dataValue, this.valueType));
            }
            return adapter.unmarshal(toConvert);
        }
        catch (Exception ex) {
            if (unmarshaller == null || unmarshaller.getErrorHandler() == null) {
                throw ConversionException.couldNotBeConverted(dataValue, this.boundType, ex);
            }
            try {
                unmarshaller.getErrorHandler().warning(new SAXParseException(null, null, ex));
                return null;
            }
            catch (SAXException e) {
                throw ConversionException.couldNotBeConverted(dataValue, this.boundType, ex);
            }
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        try {
            XmlAdapter runtimeAdapter;
            HashMap adapters;
            XmlAdapter adapter = this.xmlAdapter;
            if (marshaller != null && (adapters = (HashMap)marshaller.getProperty("xml-javatype-adapters")) != null && (runtimeAdapter = (XmlAdapter)adapters.get(this.xmlAdapterClass)) != null) {
                adapter = runtimeAdapter;
            }
            Object dataValue = adapter.marshal(objectValue);
            if (this.nestedConverter != null) {
                dataValue = this.nestedConverter.convertObjectValueToDataValue(dataValue, session);
            }
            return dataValue;
        }
        catch (Exception ex) {
            if (marshaller == null || marshaller.getErrorHandler() == null) {
                throw ConversionException.couldNotBeConverted(objectValue, this.valueType, ex);
            }
            try {
                marshaller.getErrorHandler().warning(new SAXParseException(null, null, ex));
                return null;
            }
            catch (SAXException e) {
                throw ConversionException.couldNotBeConverted(objectValue, this.valueType, ex);
            }
        }
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public Class<? extends XmlAdapter<?, ?>> getXmlAdapterClass() {
        return this.xmlAdapterClass;
    }

    public String getXmlAdapterClassName() {
        if (this.xmlAdapterClassName == null) {
            this.xmlAdapterClassName = "";
        }
        return this.xmlAdapterClassName;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        ClassLoader loader = session.getDatasourceLogin().getDatasourcePlatform().getConversionManager().getLoader();
        if (this.xmlAdapterClass == null) {
            this.xmlAdapterClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.getXmlAdapterClassName(), true, loader), ex -> JAXBException.adapterClassNotLoaded(this.getXmlAdapterClassName(), ex));
        }
        if (!XmlAdapter.class.isAssignableFrom(this.xmlAdapterClass)) {
            throw JAXBException.invalidAdapterClass(this.getXmlAdapterClassName());
        }
        this.setBoundTypeAndValueTypeInCaseOfGenericXmlAdapter();
        try {
            try {
                this.xmlAdapter = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(this.getXmlAdapterClass()));
            }
            catch (IllegalAccessException e) {
                Constructor ctor = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getDeclaredConstructorFor(this.xmlAdapterClass, new Class[0], true));
                this.xmlAdapter = (XmlAdapter)PrivilegedAccessHelper.invokeConstructor(ctor, new Object[0]);
            }
        }
        catch (Exception ex2) {
            throw JAXBException.adapterClassCouldNotBeInstantiated(this.getXmlAdapterClassName(), ex2);
        }
        if (this.nestedConverter != null) {
            if (this.nestedConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.nestedConverter).convertClassNamesToClasses(loader);
            }
            this.nestedConverter.initialize(mapping, session);
        }
    }

    private void setBoundTypeAndValueTypeInCaseOfGenericXmlAdapter() {
        Type[] parameterizedTypeArguments = GenericsClassHelper.getParameterizedTypeArguments(this.xmlAdapterClass, XmlAdapter.class);
        if (null != parameterizedTypeArguments) {
            Class<?> boundTypeClass;
            Class<?> valueTypeClass = GenericsClassHelper.getClassOfType(parameterizedTypeArguments[0]);
            if (null != valueTypeClass) {
                this.valueType = valueTypeClass;
            }
            if (this.valueType.isInterface()) {
                this.valueType = Object.class;
            }
            if (null != (boundTypeClass = GenericsClassHelper.getClassOfType(parameterizedTypeArguments[1]))) {
                this.boundType = boundTypeClass;
            }
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public void setSchemaType(QName qname) {
        this.schemaType = qname;
    }

    public void setXmlAdapterClass(Class<? extends XmlAdapter<?, ?>> xmlAdapterClass) {
        this.xmlAdapterClass = xmlAdapterClass;
    }

    public void setXmlAdapterClassName(String xmlAdapterClassName) {
        this.xmlAdapterClassName = xmlAdapterClassName;
    }

    public CoreConverter<DatabaseMapping, Session> getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(CoreConverter<DatabaseMapping, Session> nestedConverter) {
        this.nestedConverter = nestedConverter;
    }
}

