/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.ConcurrencySemaphore;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.ReadLockManager;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class WriteLockManager {
    private static final Boolean ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_FALSE = false;
    private static final Boolean ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_TRUE = true;
    private static final Map<Thread, Set<ConcurrencyManager>> THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS = new ConcurrentHashMap<Thread, Set<ConcurrencyManager>>();
    private static final Map<Thread, Set<Object>> MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET = new ConcurrentHashMap<Thread, Set<Object>>();
    private static final ThreadLocal<Boolean> SEMAPHORE_THREAD_LOCAL_VAR = new ThreadLocal();
    private static final int SEMAPHORE_MAX_NUMBER_THREADS = ConcurrencyUtil.SINGLETON.getNoOfThreadsAllowedToDoWriteLockManagerAcquireRequiredLocksInParallel();
    private static final Semaphore SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_WRITE_LOCK_MANAGER = new Semaphore(SEMAPHORE_MAX_NUMBER_THREADS);
    private transient ConcurrencySemaphore writeLockManagerSemaphore = new ConcurrencySemaphore(SEMAPHORE_THREAD_LOCAL_VAR, SEMAPHORE_MAX_NUMBER_THREADS, SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_WRITE_LOCK_MANAGER, this, "write_lock_manager_semaphore_acquired_01");
    public static final int MAXTRIES = 10000;
    public static final int MAX_WAIT = 600000;
    protected ExposedNodeLinkedList prevailingQueue;
    private final Lock toWaitOnLock = new ReentrantLock();
    private final Lock instancePrevailingQueueLock = new ReentrantLock();
    private final Condition toWaitOnLockCondition = this.toWaitOnLock.newCondition();

    public WriteLockManager() {
        this.prevailingQueue = new ExposedNodeLinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession cloningSession) {
        long whileStartTimeMillis = System.currentTimeMillis();
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        boolean successful = false;
        IdentityHashMap lockedObjects = new IdentityHashMap();
        IdentityHashMap<Object, Object> refreshedObjects = new IdentityHashMap<Object, Object>();
        ConcurrencyManager lastCacheKeyWeNeededToWaitToAcquire = null;
        try {
            CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession);
            int tries = 0;
            while (toWaitOn != null) {
                Object waitObject;
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
                lastCacheKeyWeNeededToWaitToAcquire = toWaitOn;
                lastCacheKeyWeNeededToWaitToAcquire.putThreadAsWaitingToAcquireLockForWriting(currentThread, stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(...)");
                ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(toWaitOn, whileStartTimeMillis, lockManager, readLockManager, ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_TRUE);
                this.toWaitOnLock.lock();
                try {
                    try {
                        if (toWaitOn.isAcquired()) {
                            this.toWaitOnLockCondition.await(ConcurrencyUtil.SINGLETON.getAcquireWaitTime(), TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    this.toWaitOnLock.unlock();
                }
                if ((waitObject = toWaitOn.getObject()) != null) {
                    cloningSession.checkAndRefreshInvalidObject(waitObject, toWaitOn, cloningSession.getDescriptor(waitObject));
                    refreshedObjects.put(waitObject, waitObject);
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession)) == null || ++tries <= 10000) continue;
                throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
            }
            successful = true;
        }
        catch (InterruptedException exception) {
            throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
        }
        finally {
            if (lastCacheKeyWeNeededToWaitToAcquire != null) {
                lastCacheKeyWeNeededToWaitToAcquire.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
            }
            if (!successful) {
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (!refreshedObjects.containsKey(objectForClone) && cloningSession.isConsideredInvalid(objectForClone, cacheKey, descriptor)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, cacheKey);
            } else {
                objectForClone = cacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, cacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, refreshedObjects, descriptor, cloningSession);
        }
        return cacheKey;
    }

    public void transitionToDeferredLocks(MergeManager mergeManager) {
        try {
            if (mergeManager.isTransitionedToDeferredLocks()) {
                return;
            }
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.transitionToDeferredLock();
            }
            mergeManager.transitionToDeferredLocks();
        }
        catch (RuntimeException ex) {
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.release();
            }
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).setIsThreadComplete(true);
            ConcurrencyManager.removeDeferredLockManager(Thread.currentThread());
            mergeManager.getAcquiredLocks().clear();
            throw ex;
        }
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(objectForClone);
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                if (isPartialObject && !fetchGroupManager.isAttributeFetched(objectForClone, mapping.getAttributeName())) continue;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    if (objectToLock == null) continue;
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, cloningSession);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, cloningSession);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, cloningSession);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        boolean semaphoreWasAcquired = false;
        boolean useSemaphore = ConcurrencyUtil.SINGLETON.isUseSemaphoreToLimitConcurrencyOnWriteLockManagerAcquireRequiredLocks();
        try {
            semaphoreWasAcquired = this.writeLockManagerSemaphore.acquireSemaphoreIfAppropriate(useSemaphore);
            this.acquireRequiredLocksInternal(mergeManager, changeSet);
        }
        finally {
            this.writeLockManagerSemaphore.releaseSemaphoreAllowOtherThreadsToStartDoingObjectBuilding(semaphoreWasAcquired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireRequiredLocksInternal(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        Thread currentThread = Thread.currentThread();
        long timeWhenLocksToAcquireLoopStarted = System.currentTimeMillis();
        WriteLockManager.populateMapThreadToObjectIdsWithChagenSet(currentThread, changeSet.getAllChangeSets().values());
        WriteLockManager.clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread);
        try {
            mergeManager.setLockThread(Thread.currentThread());
            AbstractSession session = mergeManager.getSession();
            if (session.isUnitOfWork()) {
                session = session.getParent();
            }
            block20: while (locksToAcquire) {
                locksToAcquire = false;
                CoreDescriptor descriptor = null;
                for (ObjectChangeSet objectChangeSet : changeSet.getAllChangeSets().values()) {
                    if (mergeManager.shouldMergeChangesIntoDistributedCache() && objectChangeSet.getSynchronizationType() == 2 || objectChangeSet.getId() == null) continue;
                    descriptor = objectChangeSet.getDescriptor();
                    if (descriptor == null) {
                        descriptor = session.getDescriptor((Class)objectChangeSet.getClassType(session));
                        objectChangeSet.setDescriptor((ClassDescriptor)descriptor);
                    }
                    if (((ClassDescriptor)descriptor).getCachePolicy().shouldIsolateObjectsInUnitOfWork()) continue;
                    AbstractSession targetSession = session.getParentIdentityMapSession((ClassDescriptor)descriptor, true, true);
                    CacheKey activeCacheKey = this.attemptToAcquireLock((ClassDescriptor)descriptor, objectChangeSet.getId(), targetSession);
                    if (activeCacheKey == null) {
                        if (this.prevailingQueue.getFirst() == mergeManager) {
                            activeCacheKey = this.waitOnObjectLock((ClassDescriptor)descriptor, objectChangeSet.getId(), targetSession, (int)Math.round((0.001 + Math.random()) * 500.0));
                        }
                        if (activeCacheKey == null) {
                            block38: {
                                this.releaseAllAcquiredLocks(mergeManager);
                                activeCacheKey = targetSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(objectChangeSet.getId(), ((ClassDescriptor)descriptor).getJavaClass(), (ClassDescriptor)descriptor);
                                if (session.shouldLog(2, "cache")) {
                                    Object[] params = new Object[]{((ClassDescriptor)descriptor).getJavaClass(), objectChangeSet.getId(), Thread.currentThread().getName()};
                                    session.log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", params, null);
                                }
                                if (mergeManager.getWriteLockQueued() == null) {
                                    this.instancePrevailingQueueLock.lock();
                                    try {
                                        mergeManager.setQueueNode(this.prevailingQueue.addLastElement(mergeManager));
                                    }
                                    finally {
                                        this.instancePrevailingQueueLock.unlock();
                                    }
                                }
                                mergeManager.setWriteLockQueued(objectChangeSet.getId());
                                try {
                                    if (activeCacheKey == null) break block38;
                                    activeCacheKey.getInstanceLock().lock();
                                    try {
                                        if (activeCacheKey.isAcquired() && activeCacheKey.getActiveThread() != Thread.currentThread()) {
                                            Thread thread = activeCacheKey.getActiveThread();
                                            if (thread.isAlive()) {
                                                long time = System.currentTimeMillis();
                                                activeCacheKey.getInstanceLockCondition().await(600000L, TimeUnit.MILLISECONDS);
                                                if (System.currentTimeMillis() - time >= 600000L) {
                                                    StackTraceElement[] trace;
                                                    Object[] params = new Object[]{600, ((ClassDescriptor)descriptor).getJavaClassName(), activeCacheKey.getKey(), thread.getName()};
                                                    StringBuilder buffer = new StringBuilder(TraceLocalization.buildMessage("max_time_exceeded_for_acquirerequiredlocks_wait", params));
                                                    for (StackTraceElement element : trace = thread.getStackTrace()) {
                                                        buffer.append("\t\tat");
                                                        buffer.append(element.toString());
                                                        buffer.append("\n");
                                                    }
                                                    session.log(7, "cache", buffer.toString());
                                                    session.getIdentityMapAccessor().printIdentityMapLocks();
                                                }
                                            } else {
                                                session.log(7, "cache", "releasing_invalid_lock", new Object[]{thread.getName(), ((ClassDescriptor)descriptor).getJavaClass(), objectChangeSet.getId()});
                                                while (activeCacheKey.isAcquired()) {
                                                    activeCacheKey.release();
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        activeCacheKey.getInstanceLock().unlock();
                                    }
                                }
                                catch (InterruptedException exception) {
                                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                                }
                            }
                            WriteLockManager.addCacheKeyToMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey, timeWhenLocksToAcquireLoopStarted);
                            locksToAcquire = true;
                            continue block20;
                        }
                        WriteLockManager.removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey);
                        objectChangeSet.setActiveCacheKey(activeCacheKey);
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                        continue;
                    }
                    WriteLockManager.removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey);
                    objectChangeSet.setActiveCacheKey(activeCacheKey);
                    mergeManager.getAcquiredLocks().add(activeCacheKey);
                }
            }
        }
        catch (RuntimeException exception) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw exception;
        }
        catch (InterruptedException exception) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw ConcurrencyException.waitFailureOnClientSession(exception);
        }
        catch (Error error) {
            this.releaseAllAcquiredLocks(mergeManager);
            mergeManager.getSession().logThrowable(7, "transaction", error);
            throw error;
        }
        finally {
            if (mergeManager.getWriteLockQueued() != null) {
                this.instancePrevailingQueueLock.lock();
                try {
                    this.prevailingQueue.remove(mergeManager.getQueueNode());
                }
                finally {
                    this.instancePrevailingQueueLock.unlock();
                }
                mergeManager.setWriteLockQueued(null);
            }
            WriteLockManager.clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread);
            WriteLockManager.clearMapThreadToObjectIdsWithChagenSet(currentThread);
        }
    }

    public CacheKey appendLock(Object primaryKey, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), false, descriptor);
        if (lockedCacheKey == null) {
            session.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
            lockedCacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, descriptor.getJavaClass(), descriptor, true);
            Object cachedObject = lockedCacheKey.getObject();
            if (cachedObject == null) {
                if (lockedCacheKey.getActiveThread() == Thread.currentThread()) {
                    lockedCacheKey.setObject(objectToLock);
                } else {
                    cachedObject = lockedCacheKey.waitForObject();
                }
            }
            lockedCacheKey.releaseDeferredLock();
            return lockedCacheKey;
        }
        if (lockedCacheKey.getObject() == null) {
            lockedCacheKey.setObject(objectToLock);
        }
        if (mergeManager.isTransitionedToDeferredLocks()) {
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).getActiveLocks().add(lockedCacheKey);
        } else {
            mergeManager.getAcquiredLocks().add(lockedCacheKey);
        }
        return lockedCacheKey;
    }

    protected CacheKey attemptToAcquireLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), true, descriptor);
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, Map refreshedObjects, DatabaseMapping mapping, AbstractSession cloningSession) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Object primaryKeyToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() || mapping.getReferenceDescriptor().isDescriptorForInterface() ? cloningSession.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isDescriptorTypeAggregate()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, refreshedObjects, referenceDescriptor, cloningSession);
            } else {
                CacheKey toWaitOn;
                primaryKeyToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, cloningSession);
                CacheKey cacheKey = cloningSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKeyToLock, objectToLock.getClass(), referenceDescriptor);
                if (cacheKey == null) {
                    cacheKey = new CacheKey(primaryKeyToLock);
                    cacheKey.setReadTime(System.currentTimeMillis());
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, refreshedObjects, cacheKey, referenceDescriptor, cloningSession)) != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        ArrayList<CacheKey> acquiredLocks = mergeManager.getAcquiredLocks();
        Iterator locks = acquiredLocks.iterator();
        RuntimeException exception = null;
        while (locks.hasNext()) {
            try {
                CacheKey cacheKeyToRemove = (CacheKey)locks.next();
                if (cacheKeyToRemove.getObject() == null) {
                    cacheKeyToRemove.removeFromOwningMap();
                }
                if (mergeManager.isTransitionedToDeferredLocks()) {
                    cacheKeyToRemove.releaseDeferredLock();
                    continue;
                }
                cacheKeyToRemove.release();
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        acquiredLocks.clear();
        if (exception != null) {
            throw exception;
        }
    }

    protected CacheKey waitOnObjectLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session, int waitTime) {
        return session.getIdentityMapAccessorInstance().acquireLockWithWait(primaryKey, descriptor.getJavaClass(), true, descriptor, waitTime);
    }

    public static Map<Thread, Set<ConcurrencyManager>> getThreadToFailToAcquireCacheKeys() {
        return Collections.unmodifiableMap(THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS);
    }

    public static Map<Thread, Set<Object>> getMapWriteLockManagerThreadToObjectIdsWithChangeSet() {
        return Collections.unmodifiableMap(MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET);
    }

    public static void clearMapThreadToObjectIdsWithChagenSet(Thread thread) {
        MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.remove(thread);
    }

    public static void populateMapThreadToObjectIdsWithChagenSet(Thread thread, Collection<ObjectChangeSet> objectChangeSets) {
        boolean hasKey = MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.containsKey(thread);
        if (!hasKey) {
            MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.putIfAbsent(thread, ConcurrentHashMap.newKeySet());
        }
        Set<Object> primarykeys = MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.get(thread);
        primarykeys.clear();
        for (ObjectChangeSet objectChangeSet : objectChangeSets) {
            Object primaryKey = objectChangeSet.getId();
            primarykeys.add(primaryKey);
        }
    }

    public static void clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread) {
        THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.remove(thread);
    }

    public static void addCacheKeyToMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread, ConcurrencyManager cacheKeyThatCouldNotBeAcquired, long whileStartDate) throws InterruptedException {
        if (cacheKeyThatCouldNotBeAcquired == null) {
            return;
        }
        Set<ConcurrencyManager> cacheKeysWeAreHavingDifficultyAcquiring = WriteLockManager.getCacheKeysThatCouldNotBeAcquiredByThread(thread);
        if (!cacheKeysWeAreHavingDifficultyAcquiring.contains(cacheKeyThatCouldNotBeAcquired)) {
            cacheKeysWeAreHavingDifficultyAcquiring.add(cacheKeyThatCouldNotBeAcquired);
        }
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(cacheKeyThatCouldNotBeAcquired, whileStartDate, lockManager, readLockManager, ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_FALSE);
    }

    public static void removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread, ConcurrencyManager cacheKeyThatCouldNotBeAcquired) {
        Set<ConcurrencyManager> cacheKeysWeAreHavingDifficultyAcquiring = WriteLockManager.getCacheKeysThatCouldNotBeAcquiredByThread(thread);
        cacheKeysWeAreHavingDifficultyAcquiring.remove(cacheKeyThatCouldNotBeAcquired);
    }

    private static Set<ConcurrencyManager> getCacheKeysThatCouldNotBeAcquiredByThread(Thread thread) {
        boolean hasKey = THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.containsKey(thread);
        if (!hasKey) {
            ConcurrentHashMap.KeySetView cacheKeySet = ConcurrentHashMap.newKeySet();
            THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.putIfAbsent(thread, cacheKeySet);
        }
        return THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.get(thread);
    }
}

