/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;

public abstract class AbstractEncapsulatedExpression
extends AbstractExpression {
    private boolean hasLeftParenthesis;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterIdentifier;
    private String identifier;

    protected AbstractEncapsulatedExpression(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        } else if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        this.addOrderedEncapsulatedExpressionTo(children);
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
    }

    protected abstract void addOrderedEncapsulatedExpressionTo(List<Expression> var1);

    protected boolean areLogicalIdentifiersSupported() {
        return false;
    }

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final String getIdentifier() {
        return this.getText();
    }

    public abstract boolean hasEncapsulatedExpression();

    public final boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public final boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (wordParser.startsWith(')') || word.equalsIgnoreCase("WHEN") || word.equalsIgnoreCase("SET") || word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression)) {
            return true;
        }
        if (this.areLogicalIdentifiersSupported()) {
            return false;
        }
        return word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("OR") || word.equalsIgnoreCase("BETWEEN") || word.equalsIgnoreCase("NOT BETWEEN") || wordParser.startsWith("<") || wordParser.startsWith(">") || wordParser.startsWith("=");
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward(this.getText());
        if ("LEFT(".equals(this.identifier)) {
            wordParser.moveBackward(1);
        }
        int position = wordParser.position();
        int count = wordParser.skipLeadingWhitespace();
        int whitespaceAfterLeftParenthesis = 0;
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            whitespaceAfterLeftParenthesis = count = wordParser.skipLeadingWhitespace();
        }
        this.parseEncapsulatedExpression(wordParser, whitespaceAfterLeftParenthesis, tolerant);
        if (this.hasEncapsulatedExpression()) {
            this.hasSpaceAfterIdentifier = !this.hasLeftParenthesis && count > 0;
            count = wordParser.skipLeadingWhitespace();
        }
        if (this.shouldParseRightParenthesis(wordParser, tolerant)) {
            this.hasRightParenthesis = wordParser.startsWith(')');
            if (this.hasRightParenthesis) {
                wordParser.moveForward(1);
            } else if (!this.hasLeftParenthesis && this.hasEncapsulatedExpression()) {
                this.hasSpaceAfterIdentifier = false;
                this.removeEncapsulatedExpression();
                wordParser.setPosition(position);
            } else {
                wordParser.moveBackward(count);
            }
        } else if (count > 0 && !this.hasEncapsulatedExpression()) {
            wordParser.moveBackward(count);
        }
    }

    protected abstract void parseEncapsulatedExpression(WordParser var1, int var2, boolean var3);

    protected abstract void removeEncapsulatedExpression();

    protected boolean shouldParseRightParenthesis(WordParser wordParser, boolean tolerant) {
        return true;
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        this.toParsedTextEncapsulatedExpression(writer, actual);
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
    }

    protected abstract void toParsedTextEncapsulatedExpression(StringBuilder var1, boolean var2);
}

