/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.FindOptionUtils;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredProcedureQueryImpl
extends QueryImpl
implements StoredProcedureQuery {
    protected boolean hasMoreResults;
    protected DatabaseCall executeCall;
    protected Statement executeStatement;
    protected int executeResultSetIndex = -1;
    protected int outputCursorIndex = -1;
    protected boolean isOutputCursorResultSet = false;

    protected StoredProcedureQueryImpl(EntityManagerImpl entityManager) {
        super(entityManager);
    }

    public StoredProcedureQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        super(query, entityManager);
    }

    public StoredProcedureQueryImpl(String name, EntityManagerImpl entityManager) {
        super(entityManager);
        this.queryName = name;
    }

    protected List<?> buildResultRecords(ResultSet resultSet) {
        try {
            AbstractSession session = (AbstractSession)this.getActiveSession();
            DatabaseAccessor accessor = (DatabaseAccessor)this.executeCall.getQuery().getAccessor();
            this.executeCall.setFields((Vector<DatabaseField>)null);
            this.executeCall.matchFieldOrder(resultSet, accessor, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            Vector<AbstractRecord> result = new Vector<AbstractRecord>();
            while (resultSet.next()) {
                result.add(accessor.fetchRow(this.executeCall.getFields(), this.executeCall.getFieldsArray(), resultSet, metaData, session));
            }
            resultSet.close();
            return result;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)e);
        }
    }

    public static DatabaseQuery buildResultSetMappingNameQuery(List<String> resultSetMappingNames, StoredProcedureCall call) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets() && !call.isMultipleCursorOutputProcedure());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappingNames(resultSetMappingNames);
        return query;
    }

    public static DatabaseQuery buildResultSetMappingNameQuery(List<String> resultSetMappingNames, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, StoredProcedureQueryImpl.buildResultSetMappingNameQuery(resultSetMappingNames, call), classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildResultSetMappingQuery(List<SQLResultSetMapping> resultSetMappings, StoredProcedureCall call) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets() && !call.isMultipleCursorOutputProcedure());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappings(resultSetMappings);
        return query;
    }

    public static DatabaseQuery buildResultSetMappingQuery(List<SQLResultSetMapping> resultSetMappings, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, StoredProcedureQueryImpl.buildResultSetMappingQuery(resultSetMappings, call), classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class<?> resultClass, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery query = new ReadAllQuery(resultClass);
        query.setCall(call);
        query.setIsUserDefined(true);
        query = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    @Override
    public void close() {
        if (this.executeCall != null) {
            DatabaseQuery query = this.executeCall.getQuery();
            AbstractSession session = query.getSession();
            for (Accessor accessor : query.getAccessors()) {
                session.releaseReadConnection(accessor);
            }
            try {
                if (this.executeStatement != null) {
                    DatabaseAccessor accessor = (DatabaseAccessor)query.getAccessor();
                    accessor.releaseStatement(this.executeStatement, query.getSQLString(), this.executeCall, session);
                }
            }
            catch (SQLException exception) {
                session.log(6, "connection", "exception_caught_closing_statement", exception);
            }
        }
        this.executeCall = null;
        this.executeStatement = null;
    }

    public boolean execute() {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQueryInternal().isResultSetMappingQuery()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_execute"));
            }
            this.getResultSetMappingQuery().setIsExecuteCall(true);
            this.executeCall = (DatabaseCall)this.executeReadQuery();
            this.executeStatement = this.executeCall.getStatement();
            this.entityManager.addOpenQuery(this);
            this.hasMoreResults = this.executeCall.getExecuteReturnValue();
            if (!this.hasMoreResults && this.getCall().hasOutputCursors()) {
                this.hasMoreResults = true;
                this.outputCursorIndex = 0;
                this.isOutputCursorResultSet = true;
            }
            return this.hasMoreResults;
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (PersistenceException | IllegalStateException exception) {
            this.setRollbackOnly();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)exception);
        }
    }

    @Override
    public int executeUpdate() {
        try {
            this.entityManager.checkForTransaction(true);
            if (!this.getDatabaseQueryInternal().isResultSetMappingQuery() || this.getResultSetMappingQuery().hasResultSetMappings()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_execute_update"));
            }
            if (this.execute()) {
                if (this.getActiveSession().getPlatform().isJDBCExecuteCompliant()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_execute_update"));
                }
                int n = this.getUpdateCount();
                return n;
            }
            int n = this.getUpdateCount();
            return n;
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (PersistenceException | IllegalStateException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)exception);
        }
        finally {
            this.close();
        }
    }

    public void finalize() {
        this.close();
    }

    protected StoredProcedureCall getCall() {
        return (StoredProcedureCall)this.getDatabaseQueryInternal().getCall();
    }

    @Override
    protected Map<String, Parameter<?>> getInternalParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
            int index = 0;
            for (Object parameter : this.getCall().getParameters()) {
                DatasourceCall.ParameterType parameterType = this.getCall().getParameterTypes().get(index);
                String argumentName = this.getCall().getProcedureArgumentNames().get(index);
                DatabaseField field = null;
                if (parameterType == DatasourceCall.ParameterType.INOUT) {
                    field = (DatabaseField)((Object[])parameter)[0];
                } else if (parameterType == DatasourceCall.ParameterType.IN) {
                    field = (DatabaseField)parameter;
                } else if (parameterType == DatasourceCall.ParameterType.OUT || parameterType == DatasourceCall.ParameterType.OUT_CURSOR) {
                    field = parameter instanceof OutputParameterForCallableStatement ? ((OutputParameterForCallableStatement)parameter).getOutputField() : (DatabaseField)parameter;
                }
                if (field != null) {
                    if (argumentName == null) {
                        this.parameters.put(field.getName(), new ParameterExpressionImpl(null, field.getType(), Integer.parseInt(field.getName())));
                    } else {
                        this.parameters.put(field.getName(), new ParameterExpressionImpl(null, field.getType(), field.getName()));
                    }
                }
                ++index;
            }
        }
        return this.parameters;
    }

    public Object getOutputParameterValue(int position) {
        this.entityManager.verifyOpen();
        if (this.isValidCallableStatement()) {
            try {
                Object obj = this.executeCall.getOutputParameterValue((CallableStatement)this.executeStatement, position - 1, this.entityManager.getAbstractSession());
                if (obj instanceof ResultSet) {
                    return this.getResultSetMappingQuery().buildObjectsFromRecords(this.buildResultRecords((ResultSet)obj), ++this.executeResultSetIndex);
                }
                return obj;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21_invalid_parameter_position", new Object[]{position, exception.getMessage()}), exception);
            }
        }
        return null;
    }

    public Object getOutputParameterValue(String parameterName) {
        this.entityManager.verifyOpen();
        if (this.isValidCallableStatement()) {
            try {
                Object obj = this.executeCall.getOutputParameterValue((CallableStatement)this.executeStatement, parameterName, this.entityManager.getAbstractSession());
                if (obj instanceof ResultSet) {
                    return this.getResultSetMappingQuery().buildObjectsFromRecords(this.buildResultRecords((ResultSet)obj), ++this.executeResultSetIndex);
                }
                return obj;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21_invalid_parameter_name", new Object[]{parameterName, exception.getMessage()}), exception);
            }
        }
        return null;
    }

    private boolean hasPositionalParameters() {
        for (Parameter<?> parameter : this.getParameters()) {
            if (parameter.getName() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getResultList() {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        try {
            if (this.executeStatement == null) {
                if (!this.getDatabaseQueryInternal().isResultSetMappingQuery()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_get_result_list"));
                }
                if (this.execute()) {
                    return this.getResultList();
                }
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_get_result_list"));
            }
            if (this.hasMoreResults()) {
                if (this.isOutputCursorResultSet) {
                    List results = null;
                    results = this.hasPositionalParameters() ? (List)this.getOutputParameterValue(this.getCall().getOutputCursors().get(this.outputCursorIndex++).getIndex() + 1) : (List)this.getOutputParameterValue(this.getCall().getOutputCursors().get(this.outputCursorIndex++).getName());
                    this.hasMoreResults = this.outputCursorIndex < this.getCall().getOutputCursors().size();
                    return results;
                }
                List<?> result = this.buildResultRecords(this.executeStatement.getResultSet());
                this.moveResultPointer();
                return this.getResultSetMappingQuery().buildObjectsFromRecords(result, ++this.executeResultSetIndex);
            }
            return null;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (PersistenceException | IllegalStateException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)e);
        }
    }

    protected ResultSetMappingQuery getResultSetMappingQuery() {
        if (this.executeCall != null) {
            return (ResultSetMappingQuery)this.executeCall.getQuery();
        }
        return (ResultSetMappingQuery)this.getDatabaseQuery();
    }

    @Override
    public Object getSingleResultOrNull() {
        return this.getSingleResult(false);
    }

    @Override
    public Object getSingleResult() {
        return this.getSingleResult(true);
    }

    private Object getSingleResult(boolean failOnEmpty) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        try {
            if (this.executeStatement == null) {
                if (!this.getDatabaseQueryInternal().isResultSetMappingQuery()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_get_single_result"));
                }
                if (this.execute()) {
                    Object object = this.getSingleResult(failOnEmpty);
                    return object;
                }
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_spq_query_for_get_result_list"));
            }
            if (this.hasMoreResults()) {
                List results;
                if (this.isOutputCursorResultSet) {
                    results = this.hasPositionalParameters() ? (List)this.getOutputParameterValue(this.getCall().getOutputCursors().get(this.outputCursorIndex++).getIndex() + 1) : (List)this.getOutputParameterValue(this.getCall().getOutputCursors().get(this.outputCursorIndex++).getName());
                    this.hasMoreResults = this.outputCursorIndex < this.getCall().getOutputCursors().size();
                } else {
                    List<?> result = this.buildResultRecords(this.executeStatement.getResultSet());
                    this.moveResultPointer();
                    results = this.getResultSetMappingQuery().buildObjectsFromRecords(result, ++this.executeResultSetIndex);
                }
                if (results.size() > 1) {
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                } else if (failOnEmpty && results.isEmpty()) {
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                }
                if (results.size() > 1 || this.hasMoreResults) {
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                Object e = results.get(0);
                return e;
            }
            Object results = null;
            return results;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (PersistenceException | IllegalStateException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public int getUpdateCount() {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        if (this.executeStatement != null) {
            try {
                int updateCount = this.executeStatement.getUpdateCount();
                if (updateCount > -1) {
                    this.moveResultPointer();
                }
                return updateCount;
            }
            catch (SQLException e) {
                throw this.getDetailedException(DatabaseException.sqlException(e, this.executeCall, this.executeCall.getQuery().getAccessor(), this.executeCall.getQuery().getSession(), false));
            }
        }
        return -1;
    }

    public boolean hasMoreResults() {
        this.entityManager.verifyOpen();
        return this.hasMoreResults;
    }

    protected boolean isValidCallableStatement() {
        if (this.executeStatement == null) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("jpa21_invalid_call_on_un_executed_query"));
        }
        if (!(this.executeStatement instanceof CallableStatement)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("jpa21_invalid_call_with_no_output_parameters"));
        }
        return true;
    }

    private void moveResultPointer() {
        try {
            this.hasMoreResults = this.executeStatement.getMoreResults();
        }
        catch (SQLException e) {
            this.hasMoreResults = false;
        }
    }

    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        StoredProcedureCall call = (StoredProcedureCall)this.getDatabaseQuery().getCall();
        if (mode.equals((Object)ParameterMode.IN)) {
            call.addUnamedArgument(String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.OUT)) {
            call.addUnamedOutputArgument(String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.INOUT)) {
            call.addUnamedInOutputArgument(String.valueOf(position), String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.REF_CURSOR)) {
            call.useUnnamedCursorOutputAsResultSet(position);
        }
        this.parameters = null;
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        StoredProcedureCall call = (StoredProcedureCall)this.getDatabaseQuery().getCall();
        if (mode.equals((Object)ParameterMode.IN)) {
            call.addNamedArgument(parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.OUT)) {
            call.addNamedOutputArgument(parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.INOUT)) {
            call.addNamedInOutputArgument(parameterName, parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.REF_CURSOR)) {
            call.useNamedCursorOutputAsResultSet(parameterName);
        }
        this.parameters = null;
        return this;
    }

    @Override
    public StoredProcedureQueryImpl setFirstResult(int startPosition) {
        throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_not_supported", new Object[]{"setFirstResult", "StoredProcedureQuery"}));
    }

    @Override
    public StoredProcedureQueryImpl setFlushMode(FlushModeType flushMode) {
        return (StoredProcedureQueryImpl)super.setFlushMode(flushMode);
    }

    public CacheRetrieveMode getCacheRetrieveMode() {
        return FindOptionUtils.getCacheRetrieveMode(this.entityManager.getAbstractSession(), this.getDatabaseQuery().getProperties());
    }

    public StoredProcedureQueryImpl setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        FindOptionUtils.setCacheRetrieveMode(this.getDatabaseQuery().getProperties(), cacheRetrieveMode);
        return this;
    }

    public CacheStoreMode getCacheStoreMode() {
        return FindOptionUtils.getCacheStoreMode(this.entityManager.getAbstractSession(), this.getDatabaseQuery().getProperties());
    }

    public StoredProcedureQueryImpl setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        FindOptionUtils.setCacheStoreMode(this.getDatabaseQuery().getProperties(), cacheStoreMode);
        return this;
    }

    public Integer getTimeout() {
        return FindOptionUtils.getTimeout(this.entityManager.getAbstractSession(), this.getDatabaseQuery().getProperties());
    }

    public StoredProcedureQueryImpl setTimeout(Integer timeout) {
        FindOptionUtils.setTimeout(this.getDatabaseQuery().getProperties(), timeout);
        return this;
    }

    public StoredProcedureQuery setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public StoredProcedureQueryImpl setLockMode(LockModeType lockMode) {
        return (StoredProcedureQueryImpl)super.setLockMode(lockMode);
    }

    @Override
    public StoredProcedureQueryImpl setMaxResults(int maxResult) {
        throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_not_supported", new Object[]{"setMaxResults", "StoredProcedureQuery"}));
    }

    public StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    public StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    public StoredProcedureQuery setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = StoredProcedureQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value, temporalType);
    }

    public StoredProcedureQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = StoredProcedureQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value, temporalType);
    }

    public <T> StoredProcedureQuery setParameter(Parameter<T> param, T value) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        String position = StoredProcedureQueryImpl.getParameterId(param);
        ParameterExpressionImpl parameter = (ParameterExpressionImpl)this.getInternalParameters().get(position);
        if (parameter == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{param.toString(), this.databaseQuery}));
        }
        if (!parameter.getParameterType().equals(param.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("INCORRECT_PARAMETER_TYPE", new Object[]{position, param.getParameterType()}));
        }
        return this.setParameter(position, value);
    }

    public StoredProcedureQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public StoredProcedureQuery setParameter(String name, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpenWithSetRollbackOnly();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public StoredProcedureQuery setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value, false);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    protected void setParameterInternal(String name, Object value, boolean isIndex) {
        Parameter<?> parameter = this.getInternalParameters().get(name);
        StoredProcedureCall call = (StoredProcedureCall)this.getDatabaseQuery().getCall();
        if (parameter == null) {
            if (isIndex) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{name, call.getProcedureName()}));
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{name, call.getProcedureName()}));
        }
        if (!this.isValidActualParameter(value, parameter.getParameterType())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{name, value.getClass(), parameter.getParameterType(), call.getProcedureName()}));
        }
        this.parameterValues.put(name, value);
    }
}

