/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLHelper {
    public static final String ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    public static final String ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    private static final String PROP_ACCESS_EXTERNAL_SCHEMA = "javax.xml.accessExternalSchema";
    private static final String PROP_ACCESS_EXTERNAL_DTD = "javax.xml.accessExternalDTD";
    private static final boolean XML_SECURITY_DISABLED = PrivilegedAccessHelper.getSystemPropertyBoolean("eclipselink.disableXmlSecurity", false);

    private static boolean isXMLSecurityDisabled(boolean runtimeSetting) {
        return XML_SECURITY_DISABLED || runtimeSetting;
    }

    public static SchemaFactory createSchemaFactory(String language, boolean disableSecureProcessing) throws IllegalStateException {
        SessionLog logger = AbstractSessionLog.getLog();
        try {
            SchemaFactory factory = SchemaFactory.newInstance(language);
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "schema_factory", new Object[]{factory});
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XMLHelper.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (AbstractMethodError | SAXNotRecognizedException | SAXNotSupportedException ex) {
            logger.logThrowable(7, "moxy", ex);
            throw new IllegalStateException(ex);
        }
    }

    public static SAXParserFactory createParserFactory(boolean disableSecureProcessing) throws IllegalStateException {
        SessionLog logger = AbstractSessionLog.getLog();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "saxparser_factory", new Object[]{factory});
            }
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XMLHelper.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (AbstractMethodError | ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException ex) {
            logger.logThrowable(7, "moxy", ex);
            throw new IllegalStateException(ex);
        }
    }

    public static XPathFactory createXPathFactory(boolean disableSecureProcessing) throws IllegalStateException {
        SessionLog logger = AbstractSessionLog.getLog();
        try {
            XPathFactory factory = XPathFactory.newInstance();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "xpath_factory", new Object[]{factory});
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XMLHelper.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (AbstractMethodError | XPathFactoryConfigurationException ex) {
            logger.logThrowable(7, "moxy", ex);
            throw new IllegalStateException(ex);
        }
    }

    public static TransformerFactory createTransformerFactory(boolean disableSecureProcessing) throws IllegalStateException {
        SessionLog logger = AbstractSessionLog.getLog();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "transformer_factory", new Object[]{factory});
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XMLHelper.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (AbstractMethodError | TransformerConfigurationException ex) {
            logger.logThrowable(7, "moxy", ex);
            throw new IllegalStateException(ex);
        }
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory(boolean disableSecureProcessing) throws IllegalStateException {
        SessionLog logger = AbstractSessionLog.getLog();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "documentbuilder_factory", new Object[]{factory});
            }
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", !XMLHelper.isXMLSecurityDisabled(disableSecureProcessing));
            return factory;
        }
        catch (AbstractMethodError | ParserConfigurationException ex) {
            logger.logThrowable(7, "moxy", ex);
            throw new IllegalStateException(ex);
        }
    }

    public static SchemaFactory allowExternalAccess(SchemaFactory sf, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"xsd"});
                }
                return sf;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_SCHEMA) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"xsd"});
                }
                return sf;
            }
            try {
                sf.setProperty(ACCESS_EXTERNAL_SCHEMA, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                }
            }
            catch (SAXException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return sf;
    }

    public static TransformerFactory allowExternalAccess(TransformerFactory tf, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"xsd"});
                }
                return tf;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_SCHEMA) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"xsd"});
                }
                return tf;
            }
            try {
                tf.setAttribute(ACCESS_EXTERNAL_SCHEMA, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                }
            }
            catch (IllegalArgumentException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return tf;
    }

    public static DocumentBuilderFactory allowExternalAccess(DocumentBuilderFactory dbf, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"xsd"});
                }
                return dbf;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_SCHEMA) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"xsd"});
                }
                return dbf;
            }
            try {
                dbf.setAttribute(ACCESS_EXTERNAL_SCHEMA, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                }
            }
            catch (IllegalArgumentException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return dbf;
    }

    public static XMLReader allowExternalAccess(XMLReader xmlReader, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"xsd"});
                }
                return xmlReader;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_SCHEMA) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"xsd"});
                }
                return xmlReader;
            }
            try {
                xmlReader.setProperty(ACCESS_EXTERNAL_SCHEMA, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                }
            }
            catch (SAXException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return xmlReader;
    }

    public static SchemaFactory allowExternalDTDAccess(SchemaFactory sf, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"DTD"});
                }
                return sf;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_DTD) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"DTD"});
                }
                return sf;
            }
            try {
                sf.setProperty(ACCESS_EXTERNAL_DTD, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                }
            }
            catch (SAXException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return sf;
    }

    public static DocumentBuilderFactory allowExternalDTDAccess(DocumentBuilderFactory dbf, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"DTD"});
                }
                return dbf;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_DTD) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"DTD"});
                }
                return dbf;
            }
            try {
                dbf.setAttribute(ACCESS_EXTERNAL_DTD, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                }
            }
            catch (IllegalArgumentException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return dbf;
    }

    public static XMLReader allowExternalDTDAccess(XMLReader xmlReader, String value, boolean disableSecureProcessing) {
        block7: {
            SessionLog logger = AbstractSessionLog.getLog();
            if (XMLHelper.isXMLSecurityDisabled(disableSecureProcessing)) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_disabled", new Object[]{"DTD"});
                }
                return xmlReader;
            }
            if (PrivilegedAccessHelper.getSystemProperty(PROP_ACCESS_EXTERNAL_DTD) != null) {
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_explicit", new Object[]{"DTD"});
                }
                return xmlReader;
            }
            try {
                xmlReader.setProperty(ACCESS_EXTERNAL_DTD, value);
                if (logger.shouldLog(3, "moxy")) {
                    logger.log(3, "moxy", "jaxp_sec_prop_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                }
            }
            catch (SAXException ignored) {
                if (!logger.shouldLog(4, "moxy")) break block7;
                logger.log(4, "moxy", "jaxp_sec_prop_not_supported", new Object[]{ACCESS_EXTERNAL_DTD});
                logger.logThrowable(4, "moxy", ignored);
            }
        }
        return xmlReader;
    }
}

