/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.asm.ClassWriter;
import org.eclipse.persistence.asm.EclipseLinkASMClassWriter;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.EclipseLinkClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;

public class DynamicClassWriter
implements EclipseLinkClassWriter {
    protected static final String DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES = DynamicPropertiesManager.class.getName().replace('.', '/');
    protected static final String INIT = "<init>";
    protected static final String CLINIT = "<clinit>";
    protected Class<?> parentClass;
    protected String parentClassName;
    private List<String> interfaces;
    public static int[] ICONST = new int[]{Opcodes.ICONST_0, Opcodes.ICONST_1, Opcodes.ICONST_2, Opcodes.ICONST_3, Opcodes.ICONST_4, Opcodes.ICONST_5};

    public DynamicClassWriter() {
        this(DynamicEntityImpl.class);
    }

    public DynamicClassWriter(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    public DynamicClassWriter(String parentClassName) {
        if (parentClassName == null || parentClassName.isEmpty()) {
            throw DynamicException.illegalParentClassName(parentClassName);
        }
        this.parentClassName = parentClassName;
    }

    @Override
    public Class<?> getParentClass() {
        return this.parentClass;
    }

    @Override
    public String getParentClassName() {
        return this.parentClassName;
    }

    private Class<?> getParentClass(ClassLoader loader) throws ClassNotFoundException {
        if (this.parentClass == null && this.parentClassName != null) {
            this.parentClass = loader.loadClass(this.parentClassName);
        }
        return this.parentClass;
    }

    @Override
    public byte[] writeClass(DynamicClassLoader loader, String className) throws ClassNotFoundException {
        DynamicClassLoader.EnumInfo enumInfo = loader.enumInfoRegistry.get(className);
        if (enumInfo != null) {
            return this.createEnum(enumInfo);
        }
        Class<?> parent = this.getParentClass(loader);
        this.parentClassName = parent.getName();
        if (parent.isPrimitive() || parent.isArray() || parent.isEnum() || parent.isInterface() || Modifier.isFinal(parent.getModifiers())) {
            throw new IllegalArgumentException("Invalid parent class: " + String.valueOf(parent));
        }
        String classNameAsSlashes = className.replace('.', '/');
        String parentClassNameAsSlashes = this.parentClassName.replace('.', '/');
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        ((ClassWriter)cw).visit(Opcodes.ACC_PUBLIC + Opcodes.ACC_SUPER, classNameAsSlashes, null, parentClassNameAsSlashes, this.interfaces != null ? this.interfaces.toArray(new String[0]) : null);
        ((ClassWriter)cw).visitField(Opcodes.ACC_PUBLIC + Opcodes.ACC_STATIC, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";", null, null);
        MethodVisitor mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_STATIC, CLINIT, "()V", null, null);
        mv.visitTypeInsn(Opcodes.NEW, DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES);
        mv.visitInsn(Opcodes.DUP);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES, INIT, "()V", false);
        mv.visitFieldInsn(Opcodes.PUTSTATIC, classNameAsSlashes, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";");
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(0, 0);
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC, INIT, "()V", null, null);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, parentClassNameAsSlashes, INIT, "()V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(0, 0);
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC, "fetchPropertiesManager", "()L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";", null, null);
        mv.visitFieldInsn(Opcodes.GETSTATIC, classNameAsSlashes, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";");
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(0, 0);
        this.addFields(cw, parentClassNameAsSlashes);
        this.addMethods(cw, parentClassNameAsSlashes);
        ((ClassWriter)cw).visitEnd();
        return ((ClassWriter)cw).toByteArray();
    }

    protected void addInterface(String intf) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<String>();
        }
        this.interfaces.add(intf);
    }

    protected void addFields(ClassWriter cw, String parentClassType) {
    }

    protected void addMethods(ClassWriter cw, String parentClassType) {
    }

    protected byte[] createEnum(DynamicClassLoader.EnumInfo enumInfo) {
        String enumValue2;
        String[] enumValues = enumInfo.getLiteralLabels();
        String className = enumInfo.getClassName();
        String internalClassName = className.replace('.', '/');
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        ((ClassWriter)cw).visit(Opcodes.ACC_PUBLIC + Opcodes.ACC_FINAL + Opcodes.ACC_SUPER + Opcodes.ACC_ENUM, internalClassName, null, "java/lang/Enum", null);
        for (String enumValue2 : enumValues) {
            ((ClassWriter)cw).visitField(Opcodes.ACC_PUBLIC + Opcodes.ACC_FINAL + Opcodes.ACC_STATIC + Opcodes.ACC_ENUM, enumValue2, "L" + internalClassName + ";", null, null);
        }
        ((ClassWriter)cw).visitField(Opcodes.ACC_PRIVATE + Opcodes.ACC_FINAL + Opcodes.ACC_STATIC + Opcodes.ACC_SYNTHETIC, "$VALUES", "[L" + internalClassName + ";", null, null);
        MethodVisitor mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC + Opcodes.ACC_STATIC, "values", "()[L" + internalClassName + ";", null, null);
        mv.visitFieldInsn(Opcodes.GETSTATIC, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, "[L" + internalClassName + ";", "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(Opcodes.CHECKCAST, "[L" + internalClassName + ";");
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 0);
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC + Opcodes.ACC_STATIC, "valueOf", "(Ljava/lang/String;)L" + internalClassName + ";", null, null);
        mv.visitLdcInsn(Type.getType("L" + internalClassName + ";").unwrap());
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKESTATIC, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(Opcodes.CHECKCAST, internalClassName);
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(2, 1);
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PRIVATE, INIT, "(Ljava/lang/String;I)V", null, null);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitVarInsn(Opcodes.ALOAD, 1);
        mv.visitVarInsn(Opcodes.ILOAD, 2);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, "java/lang/Enum", INIT, "(Ljava/lang/String;I)V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(3, 3);
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_STATIC, CLINIT, "()V", null, null);
        int lastCount = 0;
        int i = 0;
        while (i < enumValues.length) {
            enumValue2 = enumValues[i];
            mv.visitTypeInsn(Opcodes.NEW, internalClassName);
            mv.visitInsn(Opcodes.DUP);
            mv.visitLdcInsn(enumValue2);
            if (i <= 5) {
                mv.visitInsn(ICONST[i]);
            } else if (i <= 127) {
                mv.visitIntInsn(Opcodes.BIPUSH, i);
            } else {
                mv.visitIntInsn(Opcodes.SIPUSH, i);
            }
            mv.visitMethodInsn(Opcodes.INVOKESPECIAL, internalClassName, INIT, "(Ljava/lang/String;I)V", false);
            mv.visitFieldInsn(Opcodes.PUTSTATIC, internalClassName, enumValue2, "L" + internalClassName + ";");
            lastCount = i++;
        }
        if (lastCount < 5) {
            mv.visitInsn(ICONST[lastCount + 1]);
        } else if (lastCount < 127) {
            mv.visitIntInsn(Opcodes.BIPUSH, lastCount + 1);
        } else {
            mv.visitIntInsn(Opcodes.SIPUSH, lastCount + 1);
        }
        mv.visitTypeInsn(Opcodes.ANEWARRAY, internalClassName);
        for (i = 0; i < enumValues.length; ++i) {
            enumValue2 = enumValues[i];
            mv.visitInsn(Opcodes.DUP);
            if (i <= 5) {
                mv.visitInsn(ICONST[i]);
            } else if (i <= 127) {
                mv.visitIntInsn(Opcodes.BIPUSH, i);
            } else {
                mv.visitIntInsn(Opcodes.SIPUSH, i);
            }
            mv.visitFieldInsn(Opcodes.GETSTATIC, internalClassName, enumValue2, "L" + internalClassName + ";");
            mv.visitInsn(Opcodes.AASTORE);
        }
        mv.visitFieldInsn(Opcodes.PUTSTATIC, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(4, 0);
        ((ClassWriter)cw).visitEnd();
        return ((ClassWriter)cw).toByteArray();
    }

    protected boolean verify(Class<?> dynamicClass, ClassLoader loader) throws ClassNotFoundException {
        Class<?> parent = this.getParentClass(loader);
        return dynamicClass != null && parent.isAssignableFrom(dynamicClass);
    }

    protected String[] getInterfaces() {
        return null;
    }

    protected DynamicClassWriter createCopy(Class<?> parentClass) {
        return new DynamicClassWriter(parentClass);
    }

    @Override
    public boolean isCompatible(EclipseLinkClassWriter writer) {
        if (writer == null) {
            return false;
        }
        if (this.getClass() != writer.getClass()) {
            return false;
        }
        if (this.getParentClass() == null) {
            return this.getParentClassName() != null && this.getParentClassName().equals(writer.getParentClassName());
        }
        return this.getParentClass() == writer.getParentClass();
    }

    public String toString() {
        String parentName = this.getParentClass() == null ? this.getParentClassName() : this.getParentClass().getName();
        return this.getClass().getSimpleName() + "(" + parentName + ")";
    }
}

