/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.internal.oxm;

/**
 * INTERNAL:
 * <p><b>Purpose</b>: This is a non-synchronized, reusable implementation of
 * StringBuffer.
 * @author mmacivor
 */

public class StrBuffer implements CharSequence {
    private int numChar; //The number of characters currently in this buffer
    private char[] myBuf;

    public StrBuffer() {
        this(80);
    }

    public StrBuffer(int length) {
        myBuf = new char[length];
        numChar = 0;
    }

    /*
     * Clears the StringBuffer to be reused.
     */
    public void reset() {
        numChar = 0;
    }

    private void increaseCapacity(int minStorage) {
        int newStorage = (myBuf.length * 2) + 5;
        if(newStorage < minStorage) {
            newStorage = minStorage;
        }
        char[] newBuf = new char[newStorage];
        System.arraycopy(this.myBuf, 0, newBuf, 0, this.numChar);
        this.myBuf = newBuf;
    }

    public StrBuffer append(String str) {
        int strlen = str.length();
        int newLength = this.numChar + strlen;
        if(newLength > this.myBuf.length) {
            increaseCapacity(newLength);
        }
        str.getChars(0, strlen, this.myBuf, this.numChar);
        this.numChar = newLength;
        return this;
    }

    public StrBuffer append(char[] chars, int start, int length) {
        int newLength = this.numChar + length;
        if(newLength > this.myBuf.length) {
            increaseCapacity(newLength);
        }
        System.arraycopy(chars, start, this.myBuf, numChar, length);
        this.numChar = newLength;
        return this;
    }
    @Override
    public int length() {
        return numChar;
    }

    @Override
    public String toString() {
        return new String(this.myBuf, 0, this.numChar);
    }

    @Override
    public char charAt(int index) {
        return myBuf[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.myBuf, start, end);
    }

}
