/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.databaseaccess.SimpleAppendCallCustomParameter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.Call;

public class Oracle8Platform
extends OraclePlatform {
    protected boolean usesLocatorForLOBWrite = true;
    protected int lobValueLimits = 0;

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        return fieldTypeMapping;
    }

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle8Platform)) {
            return;
        }
        Oracle8Platform oracle8Platform = (Oracle8Platform)platform;
        oracle8Platform.setShouldUseLocatorForLOBWrite(this.shouldUseLocatorForLOBWrite());
        oracle8Platform.setLobValueLimits(this.getLobValueLimits());
    }

    protected boolean lobValueExceedsLimit(Object value) {
        if (value == null) {
            return false;
        }
        int limit = this.getLobValueLimits();
        if (value instanceof byte[]) {
            return ((byte[])value).length >= limit;
        }
        if (value instanceof String) {
            return ((String)value).length() >= limit;
        }
        return false;
    }

    @Override
    public Connection getConnection(AbstractSession session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        Class<?> type = field.getType();
        if (ClassConstants.BLOB.equals(type) || ClassConstants.CLOB.equals(type)) {
            if (value == null) {
                return null;
            }
            value = this.convertToDatabaseType(value);
            if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(value)) {
                ((DatabaseCall)call).addContext(field, value);
                value = ClassConstants.BLOB.equals(type) ? (shouldBind ? (Object)new byte[1] : new SimpleAppendCallCustomParameter("empty_blob()")) : (shouldBind ? new String(" ") : new SimpleAppendCallCustomParameter("empty_clob()"));
            }
            return value;
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        Class<?> type;
        if (this.shouldUseLocatorForLOBWrite() && (ClassConstants.BLOB.equals(type = field.getType()) || ClassConstants.CLOB.equals(type))) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field);
    }

    @Override
    public void writeLOB(DatabaseField field, Object value, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field.getType())) {
            Blob blob = (Blob)resultSet.getObject(field.getName());
            blob.setBytes(1L, (byte[])value);
            session.log(1, "sql", "write_BLOB", blob.length(), field.getName());
        } else if (this.isClob(field.getType())) {
            Clob clob = (Clob)resultSet.getObject(field.getName());
            clob.setString(1L, (String)value);
            session.log(1, "sql", "write_CLOB", clob.length(), field.getName());
        }
    }

    protected boolean isBlob(Class<?> type) {
        return ClassConstants.BLOB.equals(type);
    }

    protected boolean isClob(Class<?> type) {
        return ClassConstants.CLOB.equals(type);
    }

    @Override
    public boolean isNativeConnectionRequiredForLobLocator() {
        return true;
    }

    public void setShouldUseLocatorForLOBWrite(boolean usesLocatorForLOBWrite) {
        this.usesLocatorForLOBWrite = usesLocatorForLOBWrite;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }

    @Override
    public Array createArray(String elementDataTypeName, Object[] elements, Connection connection) throws SQLException {
        return new ARRAY(new ArrayDescriptor(elementDataTypeName, connection), connection, (Object)elements);
    }

    @Override
    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return new STRUCT(new StructDescriptor(structTypeName, connection), connection, attributes);
    }

    @Override
    public Object getRefValue(Ref ref, Connection connection) throws SQLException {
        ((REF)ref).setPhysicalConnectionOf(connection);
        return ((REF)ref).getValue();
    }

    @Override
    public void freeTemporaryObject(Object value) throws SQLException {
        if (value instanceof OracleClob && ((OracleClob)value).isTemporary()) {
            ((OracleClob)value).free();
        } else if (value instanceof OracleBlob && ((OracleBlob)value).isTemporary()) {
            ((OracleBlob)value).free();
        }
    }
}

