/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.Attribute;
import org.eclipse.persistence.asm.EclipseLinkMethodVisitor;
import org.eclipse.persistence.asm.Label;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;

public class MethodWeaver
extends EclipseLinkMethodVisitor {
    protected ClassWeaver tcw;
    protected String methodName;
    protected String methodDescriptor = null;
    protected boolean methodStarted = false;

    public MethodWeaver(ClassWeaver tcw, String methodName, String methodDescriptor, MethodVisitor mv) {
        super(mv);
        this.setCustomMethodVisitor(this);
        this.tcw = tcw;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public void visitInsn(int opcode) {
        this.weaveBeginningOfMethodIfRequired();
        if (opcode == Opcodes.valueInt("RETURN")) {
            this.weaveEndOfMethodIfRequired();
        }
        super.visitInsnSuper(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitIntInsnSuper(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitVarInsnSuper(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTypeInsnSuper(opcode, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        this.weaveAttributesIfRequired(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        this.weaveBeginningOfMethodIfRequired();
        String descClassName = "";
        if (desc.length() > 3) {
            descClassName = desc.substring(3, desc.length() - 1);
        }
        if (this.tcw.classDetails.shouldWeaveInternal() && name.equals("clone") && this.tcw.classDetails.isInSuperclassHierarchy(owner) && this.tcw.classDetails.isInMetadataHierarchy(descClassName) && this.tcw.classDetails.getNameOfSuperclassImplementingCloneMethod() == null) {
            super.visitMethodInsnSuper(opcode, owner, name, desc, intf);
            super.visitTypeInsnSuper(Opcodes.valueInt("CHECKCAST"), this.tcw.classDetails.getClassName());
            super.visitMethodInsnSuper(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_post_clone", "()Ljava/lang/Object;", false);
        } else {
            super.visitMethodInsnSuper(opcode, owner, name, desc, intf);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitJumpInsnSuper(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLabelSuper(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLdcInsnSuper(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitIincInsnSuper(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTableSwitchInsnSuper(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLookupSwitchInsnSuper(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitMultiANewArrayInsnSuper(desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTryCatchBlockSuper(start, end, handler, type);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitMaxsSuper(maxStack, maxLocals);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLocalVariableSuper(name, desc, signature, start, end, index);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLineNumberSuper(line, start);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitAttributeSuper(attr);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotationSuper(desc, visible);
    }

    @Override
    public void visitEnd() {
    }

    public void weaveAttributesIfRequired(int opcode, String owner, String name, String desc) {
        AttributeDetails attributeDetails = this.tcw.classDetails.getAttributeDetailsFromClassOrSuperClass(name);
        if (attributeDetails == null || !attributeDetails.hasField() || !this.tcw.classDetails.isInMetadataHierarchy(owner)) {
            super.visitFieldInsnSuper(opcode, owner, name, desc);
            return;
        }
        if (opcode == Opcodes.valueInt("GETFIELD")) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_get_" + name, "()" + attributeDetails.getReferenceClassType().getDescriptor(), false);
            } else {
                super.visitFieldInsnSuper(opcode, owner, name, desc);
            }
        } else if (opcode == Opcodes.valueInt("PUTFIELD")) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveChangeTracking() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_set_" + name, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
            } else {
                super.visitFieldInsnSuper(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsnSuper(opcode, owner, name, desc);
        }
    }

    public void weaveBeginningOfMethodIfRequired() {
        if (this.methodStarted) {
            return;
        }
        this.methodStarted = true;
        boolean isVirtual = false;
        AttributeDetails attributeDetails = this.tcw.classDetails.getGetterMethodToAttributeDetails().get(this.methodName);
        boolean isGetMethod = attributeDetails != null && (this.methodDescriptor.startsWith("()") || attributeDetails.isVirtualProperty() && this.methodDescriptor.startsWith("(Ljava/lang/String;)"));
        String attributeName = null;
        String referenceClassName = null;
        String setterMethodName = null;
        Type referenceClassType = null;
        String getterMethodName = null;
        int valueHoldingLocation = 1;
        int valueStorageLocation = 2;
        if (attributeDetails == null) {
            VirtualAttributeMethodInfo info = this.tcw.classDetails.getInfoForVirtualGetMethod(this.methodName);
            if (info != null && this.methodDescriptor.equals("(Ljava/lang/String;)Ljava/lang/Object;")) {
                isGetMethod = true;
                isVirtual = true;
                referenceClassName = "java.lang.Object";
                setterMethodName = info.getSetMethodName();
                referenceClassType = Type.getType("Ljava/lang/Object;");
                getterMethodName = this.methodName;
            }
        } else {
            attributeName = attributeDetails.getAttributeName();
            referenceClassName = attributeDetails.getReferenceClassName();
            setterMethodName = attributeDetails.getSetterMethodName();
            referenceClassType = attributeDetails.getReferenceClassType();
            getterMethodName = attributeDetails.getGetterMethodName();
            isVirtual = attributeDetails.isVirtualProperty();
        }
        if (isVirtual) {
            valueHoldingLocation = 2;
            valueStorageLocation = 3;
        }
        if (isVirtual || isGetMethod && !attributeDetails.hasField()) {
            if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                if (isVirtual) {
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                } else {
                    this.methodVisitor.visitLdcInsn(attributeName);
                }
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V", false);
            }
            if (!isVirtual && attributeDetails.weaveValueHolders()) {
                this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeName + "_vh", "()V", false);
                this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_" + attributeName + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "isInstantiated", "()Z", true);
                Label l0 = ASMFactory.createLabel();
                this.methodVisitor.visitJumpInsn(Opcodes.valueInt("IFNE"), l0);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                    this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), 4);
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                    this.methodVisitor.visitInsn(Opcodes.valueInt("ACONST_NULL"));
                    this.methodVisitor.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_" + attributeName + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "getValue", "()Ljava/lang/Object;", true);
                this.methodVisitor.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), referenceClassName.replace('.', '/'));
                this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), setterMethodName, "(" + referenceClassType.getDescriptor() + ")V", false);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 4);
                    this.methodVisitor.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.methodVisitor.visitLabel(l0);
            }
        } else {
            boolean isSetMethod;
            attributeDetails = this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
            boolean bl = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
            if (attributeDetails == null) {
                VirtualAttributeMethodInfo info = this.tcw.classDetails.getInfoForVirtualSetMethod(this.methodName);
                if (info != null && this.methodDescriptor.equals("(Ljava/lang/String;)Ljava/lang/Object;")) {
                    isGetMethod = true;
                    isVirtual = true;
                    referenceClassName = "java.lang.Object";
                    setterMethodName = this.methodName;
                    referenceClassType = Type.getType("Ljava/lang/Object;");
                    getterMethodName = info.getGetMethodName();
                }
            } else {
                attributeName = attributeDetails.getAttributeName();
                referenceClassName = attributeDetails.getReferenceClassName();
                setterMethodName = attributeDetails.getSetterMethodName();
                referenceClassType = attributeDetails.getReferenceClassType();
                getterMethodName = attributeDetails.getGetterMethodName();
                isVirtual = attributeDetails.isVirtualProperty();
            }
            if (isVirtual) {
                valueHoldingLocation = 2;
                valueStorageLocation = 3;
            }
            if (isVirtual || isSetMethod && !attributeDetails.hasField()) {
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    String wrapper;
                    if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                        wrapper = ClassWeaver.wrapperFor(referenceClassType.getSort());
                        this.methodVisitor.visitInsn(Opcodes.valueInt("ACONST_NULL"));
                        if (wrapper != null) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation + 1);
                        } else {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation);
                        }
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                        Label l0 = ASMFactory.createLabel();
                        this.methodVisitor.visitJumpInsn(Opcodes.valueInt("IFNULL"), l0);
                        if (wrapper != null) {
                            this.methodVisitor.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                            this.methodVisitor.visitInsn(Opcodes.valueInt("DUP"));
                        }
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        String getterArgument = "";
                        String getterReturn = referenceClassType.getDescriptor();
                        if (isVirtual) {
                            getterArgument = "Ljava/lang/String;";
                            getterReturn = "Ljava/lang/Object;";
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                        }
                        this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), getterMethodName, "(" + getterArgument + ")" + getterReturn, false);
                        if (wrapper != null) {
                            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation + 1);
                        } else {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation);
                        }
                        Label l1 = ASMFactory.createLabel();
                        this.methodVisitor.visitJumpInsn(Opcodes.valueInt("GOTO"), l1);
                        this.methodVisitor.visitLabel(l0);
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        if (isVirtual) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                        } else {
                            this.methodVisitor.visitLdcInsn(attributeName);
                        }
                        this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
                        this.methodVisitor.visitLabel(l1);
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        if (isVirtual) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                        } else {
                            this.methodVisitor.visitLdcInsn(attributeName);
                        }
                        if (wrapper != null) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), valueStorageLocation + 1);
                            this.methodVisitor.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                            this.methodVisitor.visitInsn(Opcodes.valueInt("DUP"));
                        } else {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), valueStorageLocation);
                        }
                        int opcode = referenceClassType.getOpcode(Opcodes.valueInt("ILOAD"));
                        this.methodVisitor.visitVarInsn(opcode, valueHoldingLocation);
                        if (wrapper != null) {
                            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                        }
                        this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
                    } else {
                        wrapper = ClassWeaver.wrapperFor(referenceClassType.getSort());
                        if (wrapper != null) {
                            this.methodVisitor.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                            this.methodVisitor.visitInsn(Opcodes.valueInt("DUP"));
                        }
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        String getterArgument = "";
                        String getterReturn = referenceClassType.getDescriptor();
                        if (isVirtual) {
                            getterArgument = "Ljava/lang/String;";
                            getterReturn = "Ljava/lang/Object;";
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                        }
                        this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), getterMethodName, "(" + getterArgument + ")" + getterReturn, false);
                        if (wrapper != null) {
                            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation + 1);
                        } else {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ASTORE"), valueStorageLocation);
                        }
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                        if (isVirtual) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                        } else {
                            this.methodVisitor.visitLdcInsn(attributeName);
                        }
                        if (wrapper != null) {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), valueStorageLocation + 1);
                            this.methodVisitor.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                            this.methodVisitor.visitInsn(Opcodes.valueInt("DUP"));
                        } else {
                            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), valueStorageLocation);
                        }
                        int opcode = referenceClassType.getOpcode(Opcodes.valueInt("ILOAD"));
                        this.methodVisitor.visitVarInsn(opcode, valueHoldingLocation);
                        if (wrapper != null) {
                            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                        }
                        this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
                    }
                } else if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                    this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                    if (isVirtual) {
                        this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
                    } else {
                        this.methodVisitor.visitLdcInsn(attributeName);
                    }
                    this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
                }
            }
        }
    }

    public void weaveEndOfMethodIfRequired() {
        boolean isSetMethod;
        AttributeDetails attributeDetails = this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
        boolean bl = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
        if (isSetMethod && !attributeDetails.hasField() && attributeDetails.weaveValueHolders()) {
            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V", false);
            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setValue", "(Ljava/lang/Object;)V", true);
            this.methodVisitor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            this.methodVisitor.visitFieldInsn(Opcodes.valueInt("GETFIELD"), this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
            this.methodVisitor.visitInsn(Opcodes.valueInt("ICONST_1"));
            this.methodVisitor.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setIsCoordinatedWithProperty", "(Z)V", true);
        }
    }
}

