/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SybasePlatform
extends DatabasePlatform {
    protected Map typeStrings;

    public SybasePlatform() {
        this.pingSQL = "SELECT 1";
    }

    protected Map getTypeStrings() {
        if (this.typeStrings == null) {
            this.initializeTypeStrings();
        }
        return this.typeStrings;
    }

    protected synchronized void initializeTypeStrings() {
        if (this.typeStrings == null) {
            HashMap<Integer, String> types = new HashMap<Integer, String>(30);
            types.put(new Integer(2003), "ARRAY");
            types.put(new Integer(-5), "BIGINT");
            types.put(new Integer(-2), "BINARY");
            types.put(new Integer(-7), "BIT");
            types.put(new Integer(2004), "BLOB");
            types.put(new Integer(1), "CHAR");
            types.put(new Integer(2005), "CLOB");
            types.put(new Integer(91), "DATE");
            types.put(new Integer(3), "DECIMAL");
            types.put(new Integer(8), "DOUBLE");
            types.put(new Integer(6), "FLOAT");
            types.put(new Integer(4), "INTEGER");
            types.put(new Integer(2000), "JAVA_OBJECT");
            types.put(new Integer(-4), "LONGVARBINARY");
            types.put(new Integer(-1), "LONGVARCHAR");
            types.put(new Integer(0), "NULL");
            types.put(new Integer(2), "NUMERIC");
            types.put(new Integer(1111), "OTHER");
            types.put(new Integer(7), "REAL");
            types.put(new Integer(2006), "REF");
            types.put(new Integer(5), "SMALLINT");
            types.put(new Integer(2002), "STRUCT");
            types.put(new Integer(92), "TIME");
            types.put(new Integer(93), "TIMESTAMP");
            types.put(new Integer(-6), "TINYINT");
            types.put(new Integer(-3), "VARBINARY");
            types.put(new Integer(12), "VARCHAR");
            this.typeStrings = types;
        }
    }

    @Override
    public int getJDBCType(Class javaType) {
        if (javaType == ClassConstants.BLOB) {
            return -4;
        }
        if (javaType == ClassConstants.CLOB) {
            return -1;
        }
        return super.getJDBCType(javaType);
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL() && !this.usesByteArrayBinding()) {
            writer.write("0x");
            Helper.writeHexString(bytes, writer);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendSybaseTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(58);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        int num = Math.min(9 - nanoString.length(), 3);
        while (num > 0) {
            writer.write(48);
            ++numberOfZeros;
            --num;
        }
        if (nanoString.length() + numberOfZeros > 3) {
            nanoString = nanoString.substring(0, 3 - numberOfZeros);
        }
        writer.write(nanoString);
        writer.write("'");
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected void appendSybaseCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    public ExpressionOperator atan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATN2");
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT default 0", false, false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT(32)", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 38));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 38).setLimits(38, -19, 19));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMERIC", 38).setLimits(38, -19, 19));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATETIME", false));
        return fieldTypeMapping;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return false;
    }

    @Override
    public String getSelectForUpdateString() {
        return " HOLDLOCK";
    }

    @Override
    public String getBatchDelimiterString() {
        return "";
    }

    @Override
    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    @Override
    public String getCreationOutputProcedureToken() {
        return this.getOutputProcedureToken();
    }

    @Override
    public String getInOutputProcedureToken() {
        return "OUT";
    }

    @Override
    public String getJdbcTypeName(int jdbcType) {
        return (String)this.getTypeStrings().get(new Integer(jdbcType));
    }

    @Override
    public int getMaxFieldNameSize() {
        return 22;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        String query = "SELECT * FROM sysobjects WHERE table_type <> 'SYSTEM_TABLE'";
        if (table != null) {
            query = table.indexOf(37) != -1 ? String.valueOf(query) + " AND table_name LIKE " + table : String.valueOf(query) + " AND table_name = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? String.valueOf(query) + " AND table_owner LIKE " + creator : String.valueOf(query) + " AND table_owner = " + creator;
        }
        return session.executeSelectingCall(new SQLCall(query));
    }

    @Override
    public String getOutputProcedureToken() {
        return this.useJDBCStoredProcedureSyntax() ? "" : "OUTPUT";
    }

    @Override
    public String getProcedureArgumentString() {
        return "@";
    }

    @Override
    public String getProcedureCallHeader() {
        return this.useJDBCStoredProcedureSyntax() ? "{Call " : "EXECUTE ";
    }

    @Override
    public String getProcedureCallTail() {
        return this.useJDBCStoredProcedureSyntax() ? "}" : "";
    }

    public boolean useJDBCStoredProcedureSyntax() {
        if (this.useJDBCStoredProcedureSyntax == null) {
            this.useJDBCStoredProcedureSyntax = this.driverName != null && this.driverName.equals("Sybase");
        }
        return this.useJDBCStoredProcedureSyntax;
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "@";
    }

    @Override
    public String getStoredProcedureTerminationToken() {
        return "\ngo";
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT GETDATE()");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.simpleFunction(54, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(123, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(128, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(ExpressionOperator.sybaseLocateOperator());
        this.addOperator(ExpressionOperator.sybaseLocate2Operator());
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTRING"));
        this.addOperator(this.singleArgumentSubstringOperator());
        this.addOperator(ExpressionOperator.addDate());
        this.addOperator(ExpressionOperator.dateName());
        this.addOperator(ExpressionOperator.datePart());
        this.addOperator(ExpressionOperator.dateDifference());
        this.addOperator(ExpressionOperator.difference());
        this.addOperator(ExpressionOperator.charIndex());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.reverse());
        this.addOperator(ExpressionOperator.replicate());
        this.addOperator(ExpressionOperator.right());
        this.addOperator(ExpressionOperator.cot());
        this.addOperator(ExpressionOperator.sybaseAtan2Operator());
        this.addOperator(ExpressionOperator.sybaseAddMonthsOperator());
        this.addOperator(ExpressionOperator.sybaseInStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "ISNULL"));
        this.addOperator(ExpressionOperator.sybaseToNumberOperator());
        this.addOperator(ExpressionOperator.sybaseToDateToStringOperator());
        this.addOperator(ExpressionOperator.sybaseToDateOperator());
        this.addOperator(ExpressionOperator.sybaseToCharOperator());
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(this.modOperator());
        this.addOperator(SybasePlatform.trimOperator());
        this.addOperator(SybasePlatform.trim2Operator());
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(38, "STR_REPLACE"));
        this.addOperator(SybasePlatform.extractOperator());
    }

    public static ExpressionOperator extractOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(138);
        exOperator.setName("EXTRACT");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("DATEPART(");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator trimOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(44);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("RTRIM(LTRIM(");
        ((Vector)v).add("))");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator trim2Operator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(121);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("STR_REPLACE(");
        ((Vector)v).add(", ");
        ((Vector)v).add(", NULL)");
        exOperator.printsAs(v);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    @Override
    public boolean isOutputAllowWithResultSet() {
        return false;
    }

    @Override
    public boolean isSybase() {
        return true;
    }

    @Override
    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 3.4028234663852886E38);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("99999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("9999999999999999999.9999999999999999999"));
        return values;
    }

    @Override
    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, 1.401298464324715E-44);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("-99999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return values;
    }

    public ExpressionOperator modOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(67);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(" % ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(FunctionExpression.class);
        return result;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(6);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(" =* ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public void registerOutputParameter(CallableStatement statement, int index, int jdbcType) throws SQLException {
        statement.registerOutParameter(index, jdbcType, (String)this.getTypeStrings().get(new Integer(jdbcType)));
    }

    @Override
    public boolean requiresProcedureCallBrackets() {
        return this.useJDBCStoredProcedureSyntax();
    }

    @Override
    public boolean requiresProcedureCallOuputToken() {
        return true;
    }

    @Override
    public boolean requiresTypeNameToRegisterOutputParameter() {
        return true;
    }

    @Override
    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public ExpressionOperator singleArgumentSubstringOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(133);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(", CHAR_LENGTH(");
        ((Vector)v).addElement("))");
        result.printsAs(v);
        int[] indices = new int[]{0, 1, 0};
        result.setArgumentIndices(indices);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        result.bePrefix();
        return result;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsDeleteOnCascade() {
        return false;
    }

    @Override
    public boolean supportsGlobalTempTables() {
        return true;
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TABLE ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("#" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        SybasePlatform.writeAutoAssignmentSetClause(writer, null, tempTableName, assignedFields, this);
        writer.write(" FROM ");
        writer.write(tableName);
        writer.write(", ");
        writer.write(tempTableName);
        SybasePlatform.writeAutoJoinWhereClause(writer, tableName, tempTableName, pkFields, this);
    }
}

