/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLStreamReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private UnmarshalNamespaceContext unmarshalNamespaceContext = new UnmarshalNamespaceContext();
    private IndexedAttributeList indexedAttributeList = new IndexedAttributeList();
    private boolean qNameAware;

    public XMLStreamReaderReader() {
    }

    public XMLStreamReaderReader(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler instanceof UnmarshalRecord) {
            ((UnmarshalRecord)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = false;
            if (null == this.validatingContentHandler) {
                this.contentHandler = (UnmarshalRecord)handler;
            } else {
                this.validatingContentHandler.setContentHandler(handler);
            }
        } else if (handler instanceof SAXUnmarshallerHandler) {
            ((SAXUnmarshallerHandler)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = true;
            if (null == this.validatingContentHandler) {
                this.contentHandler = (SAXUnmarshallerHandler)handler;
            } else {
                this.validatingContentHandler.setContentHandler(handler);
            }
        } else {
            super.setContentHandler(handler);
            this.qNameAware = true;
        }
    }

    public void parse(InputSource input) throws SAXException {
        if (null == this.contentHandler) {
            return;
        }
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            this.parse(xmlStreamReader);
        }
    }

    public void parse(XMLStreamReader xmlStreamReader) throws SAXException {
        this.unmarshalNamespaceContext.setXmlStreamReader(xmlStreamReader);
        this.indexedAttributeList.setXmlStreamReader(xmlStreamReader);
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlStreamReader, xmlStreamReader.getEventType());
            while (this.depth > 0) {
                int eventType = xmlStreamReader.next();
                this.parseEvent(xmlStreamReader, eventType);
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void parseEvent(XMLStreamReader xmlStreamReader, int eventType) throws SAXException {
        switch (eventType) {
            case 1: {
                ++this.depth;
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                String localName = xmlStreamReader.getLocalName();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.startElement(namespaceURI, localName, localName, this.indexedAttributeList.reset());
                        break;
                    }
                    this.contentHandler.startElement(namespaceURI, localName, prefix + ':' + localName, this.indexedAttributeList.reset());
                    break;
                }
                this.contentHandler.startElement(namespaceURI, localName, null, this.indexedAttributeList.reset());
                break;
            }
            case 2: {
                --this.depth;
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                String localName = xmlStreamReader.getLocalName();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.endElement(namespaceURI, localName, localName);
                        break;
                    }
                    this.contentHandler.endElement(namespaceURI, localName, prefix + ':' + localName);
                    break;
                }
                this.contentHandler.endElement(namespaceURI, localName, null);
                break;
            }
            case 3: {
                this.contentHandler.processingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
                break;
            }
            case 4: {
                this.parseCharactersEvent(xmlStreamReader);
                break;
            }
            case 5: {
                if (null == this.lexicalHandler) break;
                this.lexicalHandler.comment(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 6: {
                this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                char[] characters = xmlStreamReader.getText().toCharArray();
                if (null == this.lexicalHandler) {
                    this.parseCharactersEvent(xmlStreamReader);
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.parseCharactersEvent(xmlStreamReader);
                this.lexicalHandler.endCDATA();
                break;
            }
        }
    }

    protected void parseCharactersEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
    }

    private static class Attribute {
        private String localName;
        private String uri;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.localName = localName;
            this.uri = uri == null ? "" : uri;
            this.name = name;
            this.value = value;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class IndexedAttributeList
    implements Attributes {
        private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
        private XMLStreamReader xmlStreamReader;
        private Attribute[] attributes;

        private IndexedAttributeList() {
        }

        public void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        private Attribute[] attributes() {
            if (null == this.attributes) {
                int attributeCount;
                int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                if (namespaceCount + (attributeCount = this.xmlStreamReader.getAttributeCount()) == 0) {
                    this.attributes = NO_ATTRIBUTES;
                } else {
                    String localName;
                    String uri;
                    int x;
                    this.attributes = new Attribute[attributeCount + namespaceCount];
                    for (x = 0; x < attributeCount; ++x) {
                        uri = this.xmlStreamReader.getAttributeNamespace(x);
                        localName = this.xmlStreamReader.getAttributeLocalName(x);
                        String prefix = this.xmlStreamReader.getAttributePrefix(x);
                        String qName = null == prefix || prefix.length() == 0 ? localName : prefix + ':' + localName;
                        String value = this.xmlStreamReader.getAttributeValue(x);
                        this.attributes[x] = new Attribute(uri, localName, qName, value);
                    }
                    for (x = 0; x < namespaceCount; ++x) {
                        String qName;
                        uri = "http://www.w3.org/2000/xmlns/";
                        localName = this.xmlStreamReader.getNamespacePrefix(x);
                        if (null == localName || localName.length() == 0) {
                            localName = "xmlns";
                            qName = "xmlns";
                        } else {
                            qName = "xmlns:" + localName;
                        }
                        String value = this.xmlStreamReader.getNamespaceURI(x);
                        this.attributes[x + attributeCount] = new Attribute(uri, localName, qName, value);
                    }
                }
            }
            return this.attributes;
        }

        public int getIndex(String qName) {
            if (null == qName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            if (null == localName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getLength() {
            return this.attributes().length;
        }

        public String getLocalName(int index) {
            return this.attributes()[index].getLocalName();
        }

        public String getQName(int index) {
            return this.attributes()[index].getName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String name) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getURI(int index) {
            return this.attributes()[index].getUri();
        }

        public String getValue(int index) {
            return this.attributes()[index].getValue();
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes()[index].getValue();
        }

        public String getValue(String uri, String localName) {
            return this.xmlStreamReader.getAttributeValue(uri, localName);
        }

        public IndexedAttributeList reset() {
            this.attributes = null;
            return this;
        }
    }
}

