/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.packager.deb.build.ContentProvider;

public class FileContentProvider
implements ContentProvider {
    private final Path file;

    public FileContentProvider(Path file) {
        this.file = file;
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (this.file == null) {
            return null;
        }
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public boolean hasContent() {
        return this.file != null;
    }
}

