/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.packager.deb.FieldFormatter;

public class ControlFileWriter {
    private final Appendable writer;
    private final Map<String, FieldFormatter> alternateFormatters;

    public ControlFileWriter(OutputStream os) {
        this(os, null);
    }

    public ControlFileWriter(Appendable writer) {
        this(writer, null);
    }

    public ControlFileWriter(OutputStream os, Map<String, FieldFormatter> alternateFormatters) {
        this(new OutputStreamWriter(os, StandardCharsets.UTF_8), alternateFormatters);
    }

    public ControlFileWriter(Appendable writer, Map<String, FieldFormatter> alternateFormatters) {
        this.writer = writer;
        this.alternateFormatters = alternateFormatters == null ? Collections.emptyMap() : alternateFormatters;
    }

    public void writeEntries(Map<String, String> entries) throws IOException {
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.writeEntry(entry.getKey(), entry.getValue());
        }
    }

    public void writeEntry(String key, String value) throws IOException {
        this.writeEntry(key, value, Optional.empty());
    }

    public void writeEntry(String key, String value, Optional<FieldFormatter> overrideFormatter) throws IOException {
        FieldFormatter formatter = overrideFormatter.orElseGet(() -> this.alternateFormatters.getOrDefault(key, FieldFormatter.SINGLE));
        formatter.append(key, value, this.writer);
        this.writer.append('\n');
    }
}

