/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.io.File;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.CommonConstants;
import org.eclipse.datatools.connectivity.oda.flatfile.DataSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileQuery;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class Connection
implements IConnection {
    private Properties connProperties;
    private boolean isOpen = false;

    public void open(Properties connProperties) throws OdaException {
        if (connProperties == null) {
            throw new OdaException(Messages.getString("connection_CONNECTION_PROPERTIES_MISSING"));
        }
        this.connProperties = connProperties;
        this.validateHomeDir(connProperties);
        this.populateDelimiter(connProperties);
        this.populateInclColumnNames(connProperties);
        this.populateInclTypeLine(connProperties);
    }

    private void validateHomeDir(Properties connProperties) throws OdaException {
        File file;
        String homeDir = connProperties.getProperty("HOME");
        if (homeDir != null && (file = new File(homeDir)).exists()) {
            this.isOpen = true;
            return;
        }
        throw new OdaException(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR") + homeDir);
    }

    private void populateDelimiter(Properties connProperties) throws OdaException {
        String delimiterName = connProperties.getProperty("DELIMTYPE");
        if (delimiterName == null) {
            connProperties.setProperty("DELIMTYPE", "COMMA");
        } else if (CommonConstants.isValidDelimiterName(delimiterName)) {
            connProperties.setProperty("DELIMTYPE", delimiterName);
        } else {
            throw new OdaException(Messages.getString("Unsupported_Delimiter"));
        }
    }

    private void populateInclColumnNames(Properties connProperties) {
        boolean includeColumnNames = true;
        String inclColumnNames = connProperties.getProperty("INCLCOLUMNNAME");
        if (inclColumnNames != null && inclColumnNames.trim().length() > 0) {
            includeColumnNames = !inclColumnNames.equalsIgnoreCase("NO");
        }
        connProperties.setProperty("INCLCOLUMNNAME", includeColumnNames ? "YES" : "NO");
    }

    private void populateInclTypeLine(Properties connProperties) {
        boolean includeTypeLine = true;
        String inclTypeLine = connProperties.getProperty("INCLTYPELINE");
        if (inclTypeLine != null && inclTypeLine.trim().length() > 0) {
            includeTypeLine = !inclTypeLine.equalsIgnoreCase("NO");
        }
        connProperties.setProperty("INCLTYPELINE", includeTypeLine ? "YES" : "NO");
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_HAS_NOT_OPEN"));
        }
        return new FlatFileQuery(this.connProperties, this);
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }
}

