/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.diagnostics.SubscriptionDiagnostics;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PublishQueue;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.EventNotificationList;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.StatusChangeNotification;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription {
    private static final int MAX_AVAILABLE_MESSAGES = 1024;
    private static final int MAX_NOTIFICATIONS_PER_PUBLISH = 65535;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile Iterator<BaseMonitoredItem<?>> lastIterator = Collections.emptyIterator();
    private final AtomicLong itemIds = new AtomicLong(1L);
    private final Map<UInteger, BaseMonitoredItem<?>> itemsById = Maps.newConcurrentMap();
    private final AtomicReference<State> state = new AtomicReference<State>(State.Normal);
    private final AtomicReference<StateListener> stateListener = new AtomicReference();
    private final AtomicLong sequenceNumber = new AtomicLong(1L);
    private final ConcurrentSkipListMap<UInteger, NotificationMessage> availableMessages = new ConcurrentSkipListMap(UInteger::compareTo);
    private final PublishHandler publishHandler = new PublishHandler();
    private final TimerHandler timerHandler = new TimerHandler();
    private volatile ScheduledFuture<?> publishingTimer;
    private volatile boolean messageSent = false;
    private volatile boolean moreNotifications = false;
    private volatile long keepAliveCounter;
    private volatile long lifetimeCounter;
    private volatile double publishingInterval;
    private volatile long lifetimeCount;
    private volatile long maxKeepAliveCount;
    private volatile int maxNotificationsPerPublish;
    private volatile boolean publishingEnabled;
    private volatile int priority;
    private volatile SubscriptionManager subscriptionManager;
    private final SubscriptionDiagnostics subscriptionDiagnostics;
    private final SerializationContext serializationContext;
    private final UInteger subscriptionId;

    public Subscription(SubscriptionManager subscriptionManager, UInteger subscriptionId, double publishingInterval, long maxKeepAliveCount, long lifetimeCount, long maxNotificationsPerPublish, boolean publishingEnabled, int priority) {
        this.subscriptionManager = subscriptionManager;
        this.subscriptionId = subscriptionId;
        this.subscriptionDiagnostics = new SubscriptionDiagnostics(this);
        this.serializationContext = subscriptionManager.getServer().getSerializationContext();
        this.setPublishingInterval(publishingInterval);
        this.setMaxKeepAliveCount(maxKeepAliveCount);
        this.setLifetimeCount(lifetimeCount);
        this.setMaxNotificationsPerPublish(maxNotificationsPerPublish);
        this.publishingEnabled = publishingEnabled;
        this.priority = priority;
        this.resetKeepAliveCounter();
        this.resetLifetimeCounter();
        this.logger.debug("[id={}] subscription created, interval={}, keep-alive={}, lifetime={}", new Object[]{subscriptionId, publishingInterval, maxKeepAliveCount, lifetimeCount});
    }

    public synchronized void modifySubscription(ModifySubscriptionRequest request) {
        this.setPublishingInterval(request.getRequestedPublishingInterval());
        this.setMaxKeepAliveCount(request.getRequestedMaxKeepAliveCount().longValue());
        this.setLifetimeCount(request.getRequestedLifetimeCount().longValue());
        this.setMaxNotificationsPerPublish(request.getMaxNotificationsPerPublish().longValue());
        this.priority = request.getPriority().intValue();
        this.resetLifetimeCounter();
        this.subscriptionDiagnostics.getModifyCount().increment();
        this.logger.debug("[id={}] subscription modified, interval={}, keep-alive={}, lifetime={}", new Object[]{this.subscriptionId, this.publishingInterval, this.maxKeepAliveCount, this.lifetimeCount});
    }

    public synchronized List<BaseMonitoredItem<?>> deleteSubscription() {
        this.setState(State.Closed);
        ScheduledFuture<?> sf = this.publishingTimer;
        if (sf != null) {
            sf.cancel(false);
        }
        this.publishingTimer = null;
        this.logger.debug("[id={}] subscription deleted.", (Object)this.subscriptionId);
        return Lists.newArrayList(this.itemsById.values());
    }

    public synchronized void setPublishingMode(SetPublishingModeRequest request) {
        boolean previouslyEnabled = this.publishingEnabled;
        this.publishingEnabled = request.getPublishingEnabled();
        this.resetLifetimeCounter();
        if (previouslyEnabled != this.publishingEnabled) {
            if (this.publishingEnabled) {
                this.subscriptionDiagnostics.getEnableCount().increment();
            } else {
                this.subscriptionDiagnostics.getDisableCount().increment();
            }
        }
        this.logger.debug("[id={}] {}.", (Object)this.subscriptionId, (Object)(this.publishingEnabled ? "publishing enabled." : "publishing disabled."));
    }

    public synchronized void addMonitoredItems(List<BaseMonitoredItem<?>> createdItems) {
        for (BaseMonitoredItem<?> item : createdItems) {
            this.itemsById.put(item.getId(), item);
        }
        this.resetLifetimeCounter();
        this.logger.debug("[id={}] created {} MonitoredItems.", (Object)this.subscriptionId, (Object)createdItems.size());
    }

    public synchronized void removeMonitoredItems(List<BaseMonitoredItem<?>> deletedItems) {
        for (BaseMonitoredItem<?> item : deletedItems) {
            this.itemsById.remove(item.getId());
        }
        this.resetLifetimeCounter();
        this.logger.debug("[id={}] deleted {} MonitoredItems.", (Object)this.subscriptionId, (Object)deletedItems.size());
    }

    public synchronized Map<UInteger, BaseMonitoredItem<?>> getMonitoredItems() {
        return this.itemsById;
    }

    private void setPublishingInterval(double requestedPublishingInterval) {
        OpcUaServerConfigLimits limits = this.subscriptionManager.getServer().getConfig().getLimits();
        double minPublishingInterval = limits.getMinPublishingInterval();
        double maxPublishingInterval = limits.getMaxPublishingInterval();
        if (requestedPublishingInterval < minPublishingInterval || Double.isNaN(requestedPublishingInterval) || Double.isInfinite(requestedPublishingInterval)) {
            requestedPublishingInterval = limits.getDefaultPublishingInterval();
        }
        if (requestedPublishingInterval > maxPublishingInterval) {
            requestedPublishingInterval = maxPublishingInterval;
        }
        this.publishingInterval = requestedPublishingInterval;
    }

    private void setMaxKeepAliveCount(long maxKeepAliveCount) {
        double maxPublishingInterval;
        double maxSubscriptionLifetime;
        double keepAliveInterval;
        OpcUaServerConfigLimits limits = this.subscriptionManager.getServer().getConfig().getLimits();
        if (maxKeepAliveCount == 0L) {
            maxKeepAliveCount = 3L;
        }
        if ((keepAliveInterval = (double)maxKeepAliveCount * this.publishingInterval) > (maxSubscriptionLifetime = limits.getMaxSubscriptionLifetime().doubleValue())) {
            maxKeepAliveCount = (long)(maxSubscriptionLifetime / this.publishingInterval);
            if (maxKeepAliveCount < 0xFFFFFFFFL && maxSubscriptionLifetime % this.publishingInterval != 0.0) {
                ++maxKeepAliveCount;
            }
            keepAliveInterval = (double)maxKeepAliveCount * this.publishingInterval;
        }
        if (keepAliveInterval > (maxPublishingInterval = limits.getMaxPublishingInterval().doubleValue()) && (maxKeepAliveCount = (long)(maxPublishingInterval / this.publishingInterval)) < 0xFFFFFFFFL && maxPublishingInterval % this.publishingInterval != 0.0) {
            ++maxKeepAliveCount;
        }
        this.maxKeepAliveCount = maxKeepAliveCount;
    }

    private void setLifetimeCount(long lifetimeCount) {
        double lifetimeInterval = (double)lifetimeCount * this.publishingInterval;
        OpcUaServerConfigLimits limits = this.subscriptionManager.getServer().getConfig().getLimits();
        double maxSubscriptionLifetime = limits.getMaxSubscriptionLifetime();
        if (lifetimeInterval > maxSubscriptionLifetime && (lifetimeCount = (long)(maxSubscriptionLifetime / this.publishingInterval)) < 0xFFFFFFFFL && maxSubscriptionLifetime % this.publishingInterval != 0.0) {
            ++lifetimeCount;
        }
        if (this.maxKeepAliveCount < 0x55555555L) {
            if (this.maxKeepAliveCount * 3L > lifetimeCount) {
                lifetimeCount = this.maxKeepAliveCount * 3L;
            }
            lifetimeInterval = (double)lifetimeCount * this.publishingInterval;
        } else {
            lifetimeCount = 0xFFFFFFFFL;
            lifetimeInterval = Double.MAX_VALUE;
        }
        double minSubscriptionLifetime = limits.getMinSubscriptionLifetime();
        if (minSubscriptionLifetime > this.publishingInterval && minSubscriptionLifetime > lifetimeInterval && (lifetimeCount = (long)(minSubscriptionLifetime / this.publishingInterval)) < 0xFFFFFFFFL && minSubscriptionLifetime % this.publishingInterval != 0.0) {
            ++lifetimeCount;
        }
        this.lifetimeCount = lifetimeCount;
    }

    private void setMaxNotificationsPerPublish(long maxNotificationsPerPublish) {
        if (maxNotificationsPerPublish <= 0L || maxNotificationsPerPublish > 65535L) {
            maxNotificationsPerPublish = 65535L;
        }
        this.maxNotificationsPerPublish = Ints.saturatedCast((long)maxNotificationsPerPublish);
    }

    private synchronized PublishQueue publishQueue() {
        return this.subscriptionManager.getPublishQueue();
    }

    private long currentSequenceNumber() {
        return this.sequenceNumber.get();
    }

    private long nextSequenceNumber() {
        return this.sequenceNumber.getAndIncrement();
    }

    void resetLifetimeCounter() {
        this.lifetimeCounter = this.lifetimeCount;
        this.logger.debug("[id={}] lifetime counter reset to {}", (Object)this.subscriptionId, (Object)this.lifetimeCounter);
    }

    private void resetKeepAliveCounter() {
        this.keepAliveCounter = this.maxKeepAliveCount;
        this.logger.debug("[id={}] keep-alive counter reset to {}", (Object)this.subscriptionId, (Object)this.maxKeepAliveCount);
    }

    private void returnKeepAlive(ServiceRequest service) {
        ResponseHeader header = service.createResponseHeader();
        UInteger sequenceNumber = Unsigned.uint((long)this.currentSequenceNumber());
        NotificationMessage notificationMessage = new NotificationMessage(sequenceNumber, DateTime.now(), new ExtensionObject[0]);
        UInteger[] available = this.getAvailableSequenceNumbers();
        StatusCode[] acknowledgeResults = (StatusCode[])service.attr(SubscriptionManager.KEY_ACK_RESULTS).get();
        PublishResponse response = new PublishResponse(header, this.subscriptionId, available, Boolean.valueOf(this.moreNotifications), notificationMessage, acknowledgeResults, new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
        this.logger.debug("[id={}] returned keep-alive NotificationMessage sequenceNumber={}.", (Object)this.subscriptionId, (Object)sequenceNumber);
    }

    void returnStatusChangeNotification(ServiceRequest service, StatusCode status) {
        StatusChangeNotification statusChange = new StatusChangeNotification(status, null);
        UInteger sequenceNumber = Unsigned.uint((long)this.nextSequenceNumber());
        NotificationMessage notificationMessage = new NotificationMessage(sequenceNumber, DateTime.now(), new ExtensionObject[]{ExtensionObject.encode((SerializationContext)this.serializationContext, (UaStructure)statusChange)});
        ResponseHeader header = service.createResponseHeader();
        PublishResponse response = new PublishResponse(header, this.subscriptionId, new UInteger[0], Boolean.valueOf(false), notificationMessage, (StatusCode[])service.attr(SubscriptionManager.KEY_ACK_RESULTS).get(), new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
        this.logger.debug("[id={}] returned StatusChangeNotification ({}) sequenceNumber={}.", new Object[]{this.subscriptionId, status, sequenceNumber});
    }

    private void returnNotifications(ServiceRequest service) {
        LinkedHashSet items = new LinkedHashSet();
        this.lastIterator.forEachRemaining(items::add);
        this.itemsById.values().stream().filter(item -> item.hasNotifications() || item.isTriggered()).forEach(items::add);
        PeekingIterator iterator = Iterators.peekingIterator(items.iterator());
        this.gatherAndSend(iterator, service);
        this.lastIterator = iterator.hasNext() ? iterator : Collections.emptyIterator();
    }

    private void gatherAndSend(PeekingIterator<BaseMonitoredItem<?>> iterator, ServiceRequest service) {
        BaseMonitoredItem item;
        boolean gatheredAllForItem;
        ArrayList notifications = Lists.newArrayList();
        while (notifications.size() < this.maxNotificationsPerPublish && iterator.hasNext() && (gatheredAllForItem = this.gather(item = (BaseMonitoredItem)iterator.peek(), notifications, this.maxNotificationsPerPublish))) {
            iterator.next();
        }
        this.moreNotifications = iterator.hasNext();
        this.sendNotifications(service, notifications);
        if (this.moreNotifications) {
            ServiceRequest nextService = this.publishQueue().poll();
            if (nextService != null) {
                this.gatherAndSend(iterator, nextService);
            } else {
                this.publishQueue().addSubscription(this);
            }
        }
    }

    private boolean gather(BaseMonitoredItem<?> item, List<UaStructure> notifications, int maxNotifications) {
        int max = maxNotifications - notifications.size();
        return item.getNotifications(notifications, max);
    }

    private void sendNotifications(ServiceRequest service, List<UaStructure> notifications) {
        ArrayList dataNotifications = Lists.newArrayList();
        ArrayList eventNotifications = Lists.newArrayList();
        notifications.forEach(notification -> {
            if (notification instanceof MonitoredItemNotification) {
                dataNotifications.add((MonitoredItemNotification)notification);
            } else if (notification instanceof EventFieldList) {
                eventNotifications.add((EventFieldList)notification);
            }
        });
        ArrayList notificationData = Lists.newArrayList();
        if (dataNotifications.size() > 0) {
            DataChangeNotification dataChange = new DataChangeNotification(dataNotifications.toArray(new MonitoredItemNotification[0]), new DiagnosticInfo[0]);
            notificationData.add(ExtensionObject.encode((SerializationContext)this.serializationContext, (Object)dataChange, (ExpandedNodeId)dataChange.getBinaryEncodingId(), (DataTypeEncoding)OpcUaDefaultBinaryEncoding.getInstance()));
            this.subscriptionDiagnostics.getDataChangeNotificationsCount().add(dataNotifications.size());
        }
        if (eventNotifications.size() > 0) {
            EventNotificationList eventChange = new EventNotificationList(eventNotifications.toArray(new EventFieldList[0]));
            notificationData.add(ExtensionObject.encode((SerializationContext)this.serializationContext, (Object)eventChange, (ExpandedNodeId)eventChange.getBinaryEncodingId(), (DataTypeEncoding)OpcUaDefaultBinaryEncoding.getInstance()));
            this.subscriptionDiagnostics.getEventNotificationsCount().add(eventNotifications.size());
        }
        this.subscriptionDiagnostics.getNotificationsCount().add(notificationData.size());
        UInteger sequenceNumber = Unsigned.uint((long)this.nextSequenceNumber());
        NotificationMessage notificationMessage = new NotificationMessage(sequenceNumber, DateTime.now(), notificationData.toArray(new ExtensionObject[0]));
        this.availableMessages.put(notificationMessage.getSequenceNumber(), notificationMessage);
        while (this.availableMessages.size() > 1024) {
            Map.Entry<UInteger, NotificationMessage> entry = this.availableMessages.pollFirstEntry();
            if (entry == null) continue;
            this.subscriptionDiagnostics.getDiscardedMessageCount().increment();
            this.logger.debug("Discarded cached NotificationMessage with sequenceNumber={}", (Object)entry.getKey());
        }
        UInteger[] available = this.getAvailableSequenceNumbers();
        StatusCode[] acknowledgeResults = (StatusCode[])service.attr(SubscriptionManager.KEY_ACK_RESULTS).get();
        ResponseHeader header = service.createResponseHeader();
        PublishResponse response = new PublishResponse(header, this.subscriptionId, available, Boolean.valueOf(this.moreNotifications), notificationMessage, acknowledgeResults, new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
        this.logger.debug("[id={}] returning {} DataChangeNotification(s) and {} EventNotificationList(s) sequenceNumber={} moreNotifications={}.", new Object[]{this.subscriptionId, dataNotifications.size(), eventNotifications.size(), sequenceNumber, this.moreNotifications});
    }

    private boolean notificationsAvailable() {
        return this.itemsById.values().stream().anyMatch(item -> item.hasNotifications() || item.isTriggered());
    }

    private void setState(State state) {
        State previousState = this.state.getAndSet(state);
        this.logger.debug("[id={}] {} -> {}", new Object[]{this.subscriptionId, previousState, state});
        StateListener listener = this.stateListener.get();
        if (listener != null) {
            listener.onStateChange(this, previousState, state);
        }
        if (state == State.Late) {
            this.subscriptionDiagnostics.getLatePublishRequestCount().increment();
        }
    }

    public UInteger getId() {
        return this.subscriptionId;
    }

    public double getPublishingInterval() {
        return this.publishingInterval;
    }

    public long getMaxKeepAliveCount() {
        return this.maxKeepAliveCount;
    }

    public long getLifetimeCount() {
        return this.lifetimeCount;
    }

    public int getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public boolean isPublishingEnabled() {
        return this.publishingEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getKeepAliveCounter() {
        return this.keepAliveCounter;
    }

    public long getLifetimeCounter() {
        return this.lifetimeCounter;
    }

    public synchronized UInteger getMonitoredItemCount() {
        return Unsigned.uint((int)this.itemsById.size());
    }

    public synchronized UInteger getDisabledMonitoredItemCount() {
        return Unsigned.uint((long)this.itemsById.values().stream().filter(m -> m.getMonitoringMode() == MonitoringMode.Disabled).count());
    }

    public UInteger getNextSequenceNumber() {
        return Unsigned.uint((long)this.sequenceNumber.get());
    }

    public synchronized UInteger[] getAvailableSequenceNumbers() {
        Set uIntegers = this.availableMessages.keySet();
        Object[] available = uIntegers.toArray(new UInteger[0]);
        Arrays.sort(available);
        return available;
    }

    public synchronized UInteger getUnacknowledgeMessageCount() {
        return Unsigned.uint((int)this.availableMessages.size());
    }

    public synchronized SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public synchronized void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public Session getSession() {
        return this.subscriptionManager.getSession();
    }

    public long nextItemId() {
        return this.itemIds.getAndIncrement();
    }

    public void setStateListener(StateListener listener) {
        this.stateListener.set(listener);
    }

    synchronized void onPublish(ServiceRequest service) {
        State state = this.state.get();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[id={}] onPublish(), state={}, keep-alive={}, lifetime={}", new Object[]{this.subscriptionId, state, this.keepAliveCounter, this.lifetimeCounter});
        }
        if (state == State.Normal) {
            this.publishHandler.whenNormal(service);
        } else if (state == State.KeepAlive) {
            this.publishHandler.whenKeepAlive(service);
        } else if (state == State.Late) {
            this.publishHandler.whenLate(service);
        } else if (state == State.Closing) {
            this.publishHandler.whenClosing(service);
        } else if (state == State.Closed) {
            this.publishHandler.whenClosed(service);
        } else {
            throw new RuntimeException("Unhandled subscription state: " + (Object)((Object)state));
        }
    }

    synchronized void onPublishingTimer() {
        State state = this.state.get();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[id={}] onPublishingTimer(), state={}, keep-alive={}, lifetime={}", new Object[]{this.subscriptionId, state, this.keepAliveCounter, this.lifetimeCounter});
        }
        --this.lifetimeCounter;
        long startNanos = System.nanoTime();
        if (state == State.Normal) {
            this.timerHandler.whenNormal();
        } else if (state == State.KeepAlive) {
            this.timerHandler.whenKeepAlive();
        } else if (state == State.Late) {
            this.timerHandler.whenLate();
        } else if (state == State.Closed) {
            this.logger.debug("[id={}] onPublish(), state={}", (Object)this.subscriptionId, (Object)state);
        } else if (state == State.Closing) {
            this.logger.debug("[id={}] onPublish(), state={}", (Object)this.subscriptionId, (Object)state);
        } else {
            throw new RuntimeException("unhandled subscription state: " + (Object)((Object)state));
        }
        long elapsedNanos = System.nanoTime() - startNanos;
        long intervalNanos = TimeUnit.NANOSECONDS.convert(DoubleMath.roundToLong((double)this.publishingInterval, (RoundingMode)RoundingMode.UP), TimeUnit.MILLISECONDS);
        long adjustedIntervalNanos = Math.max(0L, intervalNanos - elapsedNanos);
        this.startPublishingTimer(adjustedIntervalNanos);
    }

    synchronized void startPublishingTimer() {
        long intervalNanos = TimeUnit.NANOSECONDS.convert(DoubleMath.roundToLong((double)this.publishingInterval, (RoundingMode)RoundingMode.UP), TimeUnit.MILLISECONDS);
        this.startPublishingTimer(intervalNanos);
    }

    private synchronized void startPublishingTimer(long delayNanos) {
        State s = this.state.get();
        if (s == State.Closing || s == State.Closed) {
            return;
        }
        if (this.lifetimeCounter < 1L) {
            this.logger.debug("[id={}] lifetime expired.", (Object)this.subscriptionId);
            this.setState(State.Closing);
            this.publishQueue().addSubscription(this);
        } else {
            this.publishingTimer = this.subscriptionManager.getServer().getScheduledExecutorService().schedule(this::onPublishingTimer, delayNanos, TimeUnit.NANOSECONDS);
        }
    }

    public synchronized StatusCode acknowledge(UInteger sequenceNumber) {
        if (this.availableMessages.remove(sequenceNumber) != null) {
            this.logger.debug("[id={}] sequence number acknowledged: {}", (Object)this.subscriptionId, (Object)sequenceNumber);
            return StatusCode.GOOD;
        }
        this.logger.debug("[id={}] sequence number unknown: {}", (Object)this.subscriptionId, (Object)sequenceNumber);
        return new StatusCode(2155479040L);
    }

    public synchronized NotificationMessage republish(UInteger sequenceNumber) {
        this.resetLifetimeCounter();
        this.subscriptionDiagnostics.getRepublishRequestCount().increment();
        this.subscriptionDiagnostics.getRepublishMessageRequestCount().increment();
        NotificationMessage notificationMessage = this.availableMessages.get(sequenceNumber);
        if (notificationMessage != null) {
            this.subscriptionDiagnostics.getRepublishMessageCount().increment();
        }
        return notificationMessage;
    }

    public SubscriptionDiagnostics getSubscriptionDiagnostics() {
        return this.subscriptionDiagnostics;
    }

    public static interface StateListener {
        public void onStateChange(Subscription var1, State var2, State var3);
    }

    public static enum State {
        Closed,
        Normal,
        KeepAlive,
        Late,
        Closing;

    }

    private class TimerHandler {
        private TimerHandler() {
        }

        private void whenNormal() {
            boolean publishRequestQueued = Subscription.this.publishQueue().isNotEmpty();
            boolean publishingEnabled = Subscription.this.publishingEnabled;
            boolean notificationsAvailable = Subscription.this.notificationsAvailable();
            if (publishRequestQueued && publishingEnabled && notificationsAvailable) {
                ServiceRequest service = Subscription.this.publishQueue().poll();
                if (service != null) {
                    Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                    Subscription.this.resetLifetimeCounter();
                    Subscription.this.resetKeepAliveCounter();
                    Subscription.this.messageSent = true;
                    Subscription.this.returnNotifications(service);
                } else {
                    this.whenNormal();
                }
            } else if (publishRequestQueued && !Subscription.this.messageSent && (!publishingEnabled || publishingEnabled && !notificationsAvailable)) {
                ServiceRequest service = Subscription.this.publishQueue().poll();
                if (service != null) {
                    Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                    Subscription.this.resetLifetimeCounter();
                    Subscription.this.resetKeepAliveCounter();
                    Subscription.this.messageSent = true;
                    Subscription.this.returnKeepAlive(service);
                } else {
                    this.whenNormal();
                }
            } else if (!publishRequestQueued && (!Subscription.this.messageSent || publishingEnabled && notificationsAvailable)) {
                Subscription.this.setState(State.Late);
                Subscription.this.publishQueue().addSubscription(Subscription.this);
            } else if (Subscription.this.messageSent && (!publishingEnabled || publishingEnabled && !notificationsAvailable)) {
                Subscription.this.setState(State.KeepAlive);
                Subscription.this.resetKeepAliveCounter();
                Subscription.this.keepAliveCounter--;
            } else {
                throw new IllegalStateException("unhandled subscription state");
            }
        }

        private void whenLate() {
            Subscription.this.publishQueue().addSubscription(Subscription.this);
            Subscription.this.subscriptionDiagnostics.getLatePublishRequestCount().increment();
        }

        private void whenKeepAlive() {
            boolean publishingEnabled = Subscription.this.publishingEnabled;
            boolean notificationsAvailable = Subscription.this.notificationsAvailable();
            boolean publishRequestQueued = Subscription.this.publishQueue().isNotEmpty();
            if (publishingEnabled && notificationsAvailable && publishRequestQueued) {
                ServiceRequest service = Subscription.this.publishQueue().poll();
                if (service != null) {
                    Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                    Subscription.this.setState(State.Normal);
                    Subscription.this.resetLifetimeCounter();
                    Subscription.this.resetKeepAliveCounter();
                    Subscription.this.messageSent = true;
                    Subscription.this.returnNotifications(service);
                } else {
                    this.whenKeepAlive();
                }
            } else if (publishRequestQueued && Subscription.this.keepAliveCounter == 1L && (!publishingEnabled || publishingEnabled && !notificationsAvailable)) {
                ServiceRequest service = Subscription.this.publishQueue().poll();
                if (service != null) {
                    Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                    Subscription.this.resetLifetimeCounter();
                    Subscription.this.resetKeepAliveCounter();
                    Subscription.this.returnKeepAlive(service);
                } else {
                    this.whenKeepAlive();
                }
            } else if (Subscription.this.keepAliveCounter > 1L && (!publishingEnabled || publishingEnabled && !notificationsAvailable)) {
                Subscription.this.keepAliveCounter--;
            } else if (!publishRequestQueued && (Subscription.this.keepAliveCounter == 1L || Subscription.this.keepAliveCounter > 1L && publishingEnabled && notificationsAvailable)) {
                Subscription.this.setState(State.Late);
                Subscription.this.publishQueue().addSubscription(Subscription.this);
            }
        }
    }

    private class PublishHandler {
        private PublishHandler() {
        }

        private void whenNormal(ServiceRequest service) {
            boolean publishingEnabled = Subscription.this.publishingEnabled;
            if (!publishingEnabled || publishingEnabled && !Subscription.this.moreNotifications) {
                Subscription.this.publishQueue().addRequest(service);
            } else if (publishingEnabled && Subscription.this.moreNotifications) {
                Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                Subscription.this.resetLifetimeCounter();
                Subscription.this.resetKeepAliveCounter();
                Subscription.this.messageSent = true;
                Subscription.this.returnNotifications(service);
            } else {
                throw new IllegalStateException("unhandled subscription state");
            }
        }

        private void whenLate(ServiceRequest service) {
            boolean publishingEnabled = Subscription.this.publishingEnabled;
            boolean notificationsAvailable = Subscription.this.notificationsAvailable();
            if (publishingEnabled && (notificationsAvailable || Subscription.this.moreNotifications)) {
                Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                Subscription.this.setState(State.Normal);
                Subscription.this.resetLifetimeCounter();
                Subscription.this.resetKeepAliveCounter();
                Subscription.this.messageSent = true;
                Subscription.this.returnNotifications(service);
            } else if (!publishingEnabled || publishingEnabled && !notificationsAvailable && !Subscription.this.moreNotifications) {
                Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
                Subscription.this.setState(State.KeepAlive);
                Subscription.this.resetLifetimeCounter();
                Subscription.this.resetKeepAliveCounter();
                Subscription.this.messageSent = true;
                Subscription.this.returnKeepAlive(service);
            } else {
                throw new IllegalStateException("unhandled subscription state");
            }
        }

        private void whenKeepAlive(ServiceRequest service) {
            Subscription.this.publishQueue().addRequest(service);
        }

        private void whenClosing(ServiceRequest service) {
            Subscription.this.subscriptionDiagnostics.getPublishRequestCount().increment();
            Subscription.this.returnStatusChangeNotification(service, new StatusCode(0x800A0000L));
            Subscription.this.setState(State.Closed);
        }

        private void whenClosed(ServiceRequest service) {
            Subscription.this.publishQueue().addRequest(service);
        }
    }
}

