/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyServerTest
extends WiremockArquillianTest {
    public static final int DESTINATION_SERVER_PORT = Integer.getInteger("org.eclipse.microprofile.rest.client.ssl.port", 8948);
    private static final Server DESTINATION_SERVER = new Server(DESTINATION_SERVER_PORT);

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ProxyServerTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{SimpleGetApi.class, WiremockArquillianTest.class});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullHostName() throws Exception {
        RestClientBuilder.newBuilder().proxyAddress(null, 1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidPortNumber() throws Exception {
        RestClientBuilder.newBuilder().proxyAddress("microprofile.io", 0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidPortNumber1() throws Exception {
        RestClientBuilder.newBuilder().proxyAddress("microprofile.io", -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidPortNumber2() throws Exception {
        RestClientBuilder.newBuilder().proxyAddress("microprofile.io", 65536);
    }

    @Test
    public void testProxy() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/.*")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + DESTINATION_SERVER_PORT).withAdditionalRequestHeader("X-Via", "WireMockProxy")));
        try {
            ProxyServerTest.startDestinationServer("foo");
            SimpleGetApi client = (SimpleGetApi)RestClientBuilder.newBuilder().proxyAddress("localhost", ProxyServerTest.getPort().intValue()).baseUri(URI.create("http://localhost:" + DESTINATION_SERVER_PORT + "/testProxy")).build(SimpleGetApi.class);
            Response response = client.executeGet();
            Assert.assertEquals((int)response.getStatus(), (int)200);
            Assert.assertEquals((String)((String)response.readEntity(String.class)).trim(), (String)"foo");
            Assert.assertEquals((String)response.getHeaderString("X-Via"), (String)"WireMockProxy");
        }
        finally {
            ProxyServerTest.stopDestinationServer();
        }
    }

    public static void startDestinationServer(final String responseContent) {
        DESTINATION_SERVER.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException {
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("X-Via", request.getHeader("X-Via"));
                try (PrintWriter writer = response.getWriter();){
                    writer.println(responseContent);
                }
            }
        });
        try {
            DESTINATION_SERVER.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start destination server", e);
        }
    }

    public static void stopDestinationServer() {
        try {
            DESTINATION_SERVER.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop destination server", e);
        }
    }
}

