/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.QueryParamStyleTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.StringClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class CDIQueryParamStyleTest
extends Arquillian {
    @Inject
    @RestClient
    private DefaultStringClient defaultClient;
    @Inject
    @RestClient
    private MultiPairsStringClient multiPairsClient;
    @Inject
    @RestClient
    private CommaSeparatedStringClient commaSeparatedClient;
    @Inject
    @RestClient
    private ArrayPairsStringClient arrayPairsClient;

    @Deployment
    public static WebArchive createDeployment() {
        String urlProperty = "queryParamStyle/mp-rest/uri=http://localhost:8080/stub";
        String filterProperty = "queryParamStyle/mp-rest/providers=" + ReturnWithURLRequestFilter.class.getName();
        String multiPairsProperty = MultiPairsStringClient.class.getName() + "/mp-rest/queryParamStyle=MULTI_PAIRS";
        String commaSeparatedProperty = CommaSeparatedStringClient.class.getName() + "/mp-rest/queryParamStyle=COMMA_SEPARATED";
        String arrayPairsProperty = ArrayPairsStringClient.class.getName() + "/mp-rest/queryParamStyle=ARRAY_PAIRS";
        String simpleName = CDIQueryParamStyleTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{StringClient.class, ReturnWithURLRequestFilter.class, QueryParamStyleTest.class})).addAsManifestResource((Asset)new StringAsset(String.format(filterProperty + "%n" + urlProperty + "%n" + multiPairsProperty + "%n" + commaSeparatedProperty + "%n" + arrayPairsProperty + "%n", new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void defaultStyleIsMultiPair() throws Exception {
        String expected = "?myParam=foo&myParam=bar&myParam=baz";
        QueryParamStyleTest.test(this.defaultClient, expected);
    }

    @Test
    public void explicitMultiPair() throws Exception {
        String expected = "?myParam=foo&myParam=bar&myParam=baz";
        QueryParamStyleTest.test(this.multiPairsClient, expected);
    }

    @Test
    public void commaSeparated() throws Exception {
        String expected = "?myParam=foo,bar,baz";
        QueryParamStyleTest.test(this.commaSeparatedClient, expected);
    }

    @Test
    public void arrayPairs() throws Exception {
        String expected = "?myParam[]=foo&myParam[]=bar&myParam[]=baz";
        QueryParamStyleTest.test(this.arrayPairsClient, expected);
    }

    @RegisterRestClient(configKey="queryParamStyle")
    public static interface ArrayPairsStringClient
    extends StringClient {
    }

    @RegisterRestClient(configKey="queryParamStyle")
    public static interface CommaSeparatedStringClient
    extends StringClient {
    }

    @RegisterRestClient(configKey="queryParamStyle")
    public static interface MultiPairsStringClient
    extends StringClient {
    }

    @RegisterRestClient(configKey="queryParamStyle")
    public static interface DefaultStringClient
    extends StringClient {
    }
}

