/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import com.github.tomakehurst.wiremock.client.WireMock;
import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.FollowRedirectsTest;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApiWithConfigKey;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CDIFollowRedirectsTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private SimpleGetApi defaultClient;
    @Inject
    @RestClient
    private SimpleGetApiWithConfigKey redirectingClient;

    @Deployment
    public static WebArchive createDeployment() {
        String urlProperty1 = SimpleGetApi.class.getName() + "/mp-rest/uri=" + CDIFollowRedirectsTest.getStringURL();
        String urlProperty2 = "myConfigKey/mp-rest/uri=" + CDIFollowRedirectsTest.getStringURL();
        String redirectProperty = "myConfigKey/mp-rest/followRedirects=true";
        String simpleName = CDIFollowRedirectsTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApi.class, SimpleGetApiWithConfigKey.class, FollowRedirectsTest.class, WiremockArquillianTest.class})).addAsManifestResource((Asset)new StringAsset(String.format(redirectProperty + "%n" + urlProperty1 + "%n" + urlProperty2, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    public void reset() {
        WireMock.reset();
    }

    @Test
    public void test301Default() throws Exception {
        FollowRedirectsTest.testDefault(301, this.defaultClient);
    }

    @Test
    public void test301Follows() throws Exception {
        FollowRedirectsTest.testFollows(301, this.redirectingClient);
    }

    @Test
    public void test302Default() throws Exception {
        FollowRedirectsTest.testDefault(302, this.defaultClient);
    }

    @Test
    public void test302Follows() throws Exception {
        FollowRedirectsTest.testFollows(302, this.redirectingClient);
    }

    @Test
    public void test303Default() throws Exception {
        FollowRedirectsTest.testDefault(303, this.defaultClient);
    }

    @Test
    public void test303Follows() throws Exception {
        FollowRedirectsTest.testFollows(303, this.redirectingClient);
    }

    @Test
    public void test307Default() throws Exception {
        FollowRedirectsTest.testDefault(307, this.defaultClient);
    }

    @Test
    public void test307Follows() throws Exception {
        FollowRedirectsTest.testFollows(307, this.redirectingClient);
    }
}

