/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.timeout;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.timeout.TimeoutTestBase;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;

public class TimeoutBuilderIndependentOfMPConfigTest
extends TimeoutTestBase {
    @Deployment
    public static Archive<?> createDeployment() {
        String clientName = SimpleGetApi.class.getName();
        String timeoutProps = clientName + "/mp-rest/connectTimeout=15000" + System.lineSeparator() + clientName + "/mp-rest/readTimeout=15000";
        StringAsset mpConfig = new StringAsset(timeoutProps);
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(TimeoutBuilderIndependentOfMPConfigTest.class.getSimpleName() + ".war"))).addAsWebInfResource((Asset)mpConfig, "classes/META-INF/microprofile-config.properties")).addClasses(new Class[]{SimpleGetApi.class, TimeoutTestBase.class, WiremockArquillianTest.class});
    }

    @Override
    protected SimpleGetApi getClientWithReadTimeout() {
        return (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(WiremockArquillianTest.getServerURI()).readTimeout(5L, TimeUnit.SECONDS).build(SimpleGetApi.class);
    }

    @Override
    protected SimpleGetApi getClientWithConnectTimeout() {
        return (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(URI.create(UNUSED_URL)).connectTimeout(5L, TimeUnit.SECONDS).build(SimpleGetApi.class);
    }

    @Override
    protected void checkTimeElapsed(long elapsed) {
        Assert.assertTrue((elapsed >= 5L ? 1 : 0) != 0);
        long elapsedLimit = 5 + TIMEOUT_CUSHION;
        Assert.assertTrue((elapsed < elapsedLimit ? 1 : 0) != 0, (String)("Elapsed time expected under " + elapsedLimit + " secs, but was " + elapsed + " secs."));
    }
}

