/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.timeout;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ProcessingException;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TimeoutTestBase
extends WiremockArquillianTest {
    protected static final String UNUSED_URL = AccessController.doPrivileged(() -> System.getProperty("org.eclipse.microprofile.rest.client.tck.unusedURL", "http://microprofile.io:1234/null"));
    protected static final int TIMEOUT_CUSHION = AccessController.doPrivileged(() -> Integer.getInteger("org.eclipse.microprofile.rest.client.tck.timeoutCushion", 10));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ProcessingException.class})
    public void testConnectTimeout() throws Exception {
        long startTime = System.nanoTime();
        try {
            this.getClientWithConnectTimeout().executeGet();
            Assert.fail((String)"A ProcessingException should have been thrown to indicate a timeout");
        }
        finally {
            long elapsedTime = System.nanoTime() - startTime;
            long elapsedSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
            this.checkTimeElapsed(elapsedSecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ProcessingException.class})
    public void testReadTimeout() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(30000))));
        long startTime = System.nanoTime();
        try {
            this.getClientWithReadTimeout().executeGet();
            Assert.fail((String)"A ProcessingException should have been thrown due to a read timeout");
        }
        finally {
            long elapsedTime = System.nanoTime() - startTime;
            long elapsedSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
            this.checkTimeElapsed(elapsedSecs);
        }
    }

    protected abstract SimpleGetApi getClientWithReadTimeout();

    protected abstract SimpleGetApi getClientWithConnectTimeout();

    protected abstract void checkTimeElapsed(long var1);
}

