/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.sse;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.sse.InboundSseEvent;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.sse.AbstractSseTest;
import org.eclipse.microprofile.rest.client.tck.sse.BasicReactiveStreamsTest;
import org.eclipse.microprofile.rest.client.tck.sse.HttpSseServer;
import org.eclipse.microprofile.rest.client.tck.sse.MyEventSource;
import org.eclipse.microprofile.rest.client.tck.sse.MyEventSourceServlet;
import org.eclipse.microprofile.rest.client.tck.sse.RsSseClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.reactivestreams.Publisher;
import org.reactivestreams.tck.PublisherVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.log4testng.Logger;

@Test(singleThreaded=true)
public class ReactiveStreamsPublisherTckTest
extends PublisherVerification<InboundSseEvent> {
    private static final Logger LOG = Logger.getLogger(ReactiveStreamsPublisherTckTest.class);
    private CountDownLatch cleanupLatch;
    private AtomicBoolean inMethod = new AtomicBoolean(false);

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(BasicReactiveStreamsTest.class.getSimpleName() + ".war"))).addPackage(PublisherVerification.class.getPackage())).addClasses(new Class[]{ReactiveStreamsPublisherTckTest.class, HttpSseServer.class, MyEventSource.class, MyEventSourceServlet.class, RsSseClient.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return webArchive;
    }

    public ReactiveStreamsPublisherTckTest() {
        super(new TestEnvironment(1000L));
    }

    @BeforeMethod
    private void setupLatch() {
        this.cleanupLatch = new CountDownLatch(1);
        this.inMethod.compareAndSet(false, true);
    }

    @AfterMethod
    private void countDownLatch() throws InterruptedException {
        this.inMethod.compareAndSet(true, false);
        if (!this.cleanupLatch.await(30L, TimeUnit.SECONDS)) {
            LOG.error((Object)"Server did not close long after test completed");
        }
    }

    public Publisher<InboundSseEvent> createFailedPublisher() {
        this.cleanupLatch.countDown();
        return null;
    }

    public Publisher<InboundSseEvent> createPublisher(long elements) {
        LOG.debug((Object)("createPublisher (" + elements + ")"));
        CountDownLatch latch = new CountDownLatch(1);
        try {
            AtomicReference<Throwable> serverException = AbstractSseTest.launchServer(latch, es -> {
                for (long i = 0L; i < elements; ++i) {
                    if (!this.inMethod.get()) continue;
                    es.emitData(Long.toString(i));
                }
                latch.countDown();
            }, this.cleanupLatch);
            if (serverException.get() != null) {
                throw serverException.get();
            }
            RsSseClient client = (RsSseClient)RestClientBuilder.newBuilder().baseUri(URI.create("http://localhost:" + AbstractSseTest.PORT + "/string/sse")).build(RsSseClient.class);
            Publisher<InboundSseEvent> publisher = client.getEvents();
            LOG.debug((Object)("createPublisher --> " + publisher));
            return publisher;
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to create publisher", t);
            t.printStackTrace();
            return null;
        }
    }
}

