/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.providers.LowerPriorityTestResponseExceptionMapper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DefaultExceptionMapperTest
extends WiremockArquillianTest {
    private static final int STATUS = 401;
    private static final String BODY = "body is used by this test";

    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(DefaultExceptionMapperTest.class.getSimpleName() + ".war"))).addClass(WiremockArquillianTest.class)).addClasses(new Class[]{SimpleGetApi.class, LowerPriorityTestResponseExceptionMapper.class});
    }

    @BeforeTest
    public void resetHandlers() {
        LowerPriorityTestResponseExceptionMapper.reset();
    }

    @Test
    public void testNoExceptionThrownWhenDisabledDuringBuild() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(401).withBody(BODY)));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(DefaultExceptionMapperTest.getServerURI()).property("microprofile.rest.client.disable.default.mapper", (Object)true)).build(SimpleGetApi.class);
        try {
            Response response = simpleGetApi.executeGet();
            Assert.assertEquals((int)response.getStatus(), (int)401);
        }
        catch (Exception w) {
            Assert.fail((String)"No exception should be thrown", (Throwable)w);
        }
    }

    @Test
    public void testPropagationOfResponseDetailsFromDefaultMapper() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(401).withBody(BODY)));
        SimpleGetApi simpleGetApi = (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(DefaultExceptionMapperTest.getServerURI()).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown automatically"));
        }
        catch (WebApplicationException w) {
            Response response = w.getResponse();
            Assert.assertEquals((int)response.getStatus(), (int)401, (String)"The 401 from the response should be propagated");
            String body = (String)response.readEntity(String.class);
            Assert.assertEquals((String)body, (String)BODY, (String)"The body of the response should be propagated");
            response.close();
        }
    }

    @Test
    public void testExceptionThrownWhenPropertySetToFalse() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(401).withBody(BODY)));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(DefaultExceptionMapperTest.getServerURI()).property("microprofile.rest.client.disable.default.mapper", (Object)false)).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown automatically"));
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
    }

    @Test
    public void testLowerPriorityMapperTakesPrecedenceFromDefault() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(401).withBody(BODY)));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(DefaultExceptionMapperTest.getServerURI()).register(LowerPriorityTestResponseExceptionMapper.class)).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown automatically"));
        }
        catch (WebApplicationException w) {
            Assert.assertTrue((boolean)LowerPriorityTestResponseExceptionMapper.isHandlesCalled(), (String)(LowerPriorityTestResponseExceptionMapper.class + " should handle this exception"));
            Assert.assertTrue((boolean)LowerPriorityTestResponseExceptionMapper.isThrowableCalled(), (String)(LowerPriorityTestResponseExceptionMapper.class + " should handle this exception"));
            Assert.assertEquals((String)w.getMessage(), (String)LowerPriorityTestResponseExceptionMapper.class.getSimpleName(), (String)(LowerPriorityTestResponseExceptionMapper.class + " should be in the message"));
        }
    }
}

