/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpsServer {
    private static final String CONTENT_TYPE = "Content-Type";
    private final Server server = new Server();
    private SslContextFactory sslContextFactory = new SslContextFactory();
    private String responseContent = "{\"foo\": \"bar\"}";
    private String responseContentType = ContentType.APPLICATION_JSON.getMimeType();

    public HttpsServer keyStore(String keystore, String keyStorePassword) {
        this.sslContextFactory.setKeyStorePath(keystore);
        this.sslContextFactory.setKeyStorePassword(keyStorePassword);
        return this;
    }

    public HttpsServer trustStore(String keystore, String keyStorePassword) {
        this.sslContextFactory.setTrustStorePath(keystore);
        this.sslContextFactory.setTrustStorePassword(keyStorePassword);
        this.sslContextFactory.setNeedClientAuth(true);
        this.sslContextFactory.setEndpointIdentificationAlgorithm(null);
        return this;
    }

    public HttpsServer start(int httpsPort, String httpsHostname) {
        this.server.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException {
                response.setHeader(HttpsServer.CONTENT_TYPE, HttpsServer.this.responseContentType);
                try (PrintWriter writer = response.getWriter();){
                    writer.println(HttpsServer.this.responseContent);
                }
            }
        });
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.setSecurePort(httpsPort);
        ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(httpsPort);
        sslConnector.setHost(httpsHostname);
        this.server.addConnector((Connector)sslConnector);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start https server", e);
        }
        return this;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop https server", e);
        }
    }
}

