/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.function.Consumer;
import org.eclipse.microprofile.rest.client.tck.ssl.HttpsServer;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractSslTest
extends Arquillian {
    public static final String CERT_LOCATION_FILE = "certificates-dir.txt";
    static final String HTTPS_HOST = System.getProperty("org.eclipse.microprofile.rest.client.ssl.host", "localhost");
    static final int HTTPS_PORT = Integer.valueOf(System.getProperty("org.eclipse.microprofile.rest.client.ssl.port", "8948"));
    static final String BASE_URI_STRING = "https://" + HTTPS_HOST + ":" + HTTPS_PORT;
    static final URI BASE_URI = URI.create(BASE_URI_STRING);
    static File serverKeystore;
    static File serverTruststore;
    static File clientKeystore;
    static File clientTruststore;
    static String clientTruststoreFromClasspath;
    static String clientKeystoreFromClasspath;
    static File serverWrongHostnameKeystore;
    static File clientWrongHostnameTruststore;
    static String clientWrongHostnameTruststoreFromClasspath;
    static File anotherTruststore;
    static final String PASSWORD = "password";
    private static HttpsServer httpsServer;

    public static KeyStore getKeyStore(File keystoreFile) throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        try (FileInputStream input = new FileInputStream(keystoreFile);){
            keystore.load(input, PASSWORD.toCharArray());
        }
        return keystore;
    }

    static void initializeTest(WebArchive webArchive, Consumer<HttpsServer> serverInitializer) {
        Path certificatesDirectory = AbstractSslTest.prepareCertificates();
        AbstractSslTest.initializeCertPaths(certificatesDirectory.toAbsolutePath().toString());
        AbstractSslTest.startServer(serverInitializer);
        webArchive.addAsManifestResource((Asset)new StringAsset(certificatesDirectory.toAbsolutePath().toString()), CERT_LOCATION_FILE);
    }

    static void initializeCertificateLocations() {
        InputStream certLocationStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/certificates-dir.txt");
        if (certLocationStream != null) {
            try (InputStreamReader streamReader = new InputStreamReader(certLocationStream);
                 BufferedReader reader = new BufferedReader(streamReader);){
                String certsDir = reader.readLine();
                AbstractSslTest.initializeCertPaths(certsDir);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to read certification file", e);
            }
        }
    }

    private static void initializeCertPaths(String certsDir) {
        serverKeystore = Paths.get(certsDir, "server.keystore").toFile();
        serverTruststore = Paths.get(certsDir, "server.truststore").toFile();
        clientKeystore = Paths.get(certsDir, "client.keystore").toFile();
        clientTruststore = Paths.get(certsDir, "client.truststore").toFile();
        anotherTruststore = Paths.get(certsDir, "client-different-cert.truststore").toFile();
        serverWrongHostnameKeystore = Paths.get(certsDir, "server-wrong-hostname.keystore").toFile();
        clientWrongHostnameTruststore = Paths.get(certsDir, "client-wrong-hostname.truststore").toFile();
    }

    private static Path prepareCertificates() {
        try {
            Path result = Files.createTempDirectory("ssl-test", new FileAttribute[0]);
            result.toFile().deleteOnExit();
            AbstractSslTest.copyResourceTo("client.keystore", result);
            AbstractSslTest.copyResourceTo("client.truststore", result);
            AbstractSslTest.copyResourceTo("client-different-cert.truststore", result);
            AbstractSslTest.copyResourceTo("client-wrong-hostname.truststore", result);
            AbstractSslTest.copyResourceTo("server.keystore", result);
            AbstractSslTest.copyResourceTo("server.truststore", result);
            AbstractSslTest.copyResourceTo("server-wrong-hostname.keystore", result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to prepare certificates for tests that use certificates from disk");
        }
    }

    private static void startServer(Consumer<HttpsServer> serverInitializer) {
        httpsServer = new HttpsServer();
        serverInitializer.accept(httpsServer);
        httpsServer.start(HTTPS_PORT, HTTPS_HOST);
    }

    private static void copyResourceTo(String resource, Path directory) {
        String resourceLocation = "/ssl/" + resource;
        Path diskLocation = directory.resolve(resource);
        try (InputStream input = AbstractSslTest.class.getResourceAsStream(resourceLocation);){
            Files.copy(input, diskLocation, new CopyOption[0]);
            diskLocation.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy " + resource + " to " + directory.toAbsolutePath(), e);
        }
    }

    @BeforeClass
    public static void initHttpsServer() {
        AbstractSslTest.initializeCertificateLocations();
    }

    @AfterClass
    public static void stopHttpsServer() {
        if (httpsServer != null) {
            httpsServer.stop();
        }
    }

    static {
        clientTruststoreFromClasspath = "client.truststore";
        clientKeystoreFromClasspath = "client.keystore";
        clientWrongHostnameTruststoreFromClasspath = "client-wrong-hostname.truststore";
    }
}

