/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.time.LocalDate;
import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonBClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.MyJsonBObject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class InvokeWithJsonBProviderTest
extends WiremockArquillianTest {
    private static final String CDI = "cdi";
    private static final String BUILT = "built";
    @RestClient
    @Inject
    private JsonBClient cdiJsonBClient;
    private JsonBClient builtJsonBClient;

    @Deployment
    public static WebArchive createDeployment() {
        StringAsset mpConfig = new StringAsset(JsonBClient.class.getName() + "/mp-rest/uri=" + InvokeWithJsonBProviderTest.getStringURL());
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InvokeWithJsonBProviderTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{JsonBClient.class, WiremockArquillianTest.class, MyJsonBObject.class, InvokeWithJsonBProviderTest.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebInfResource((Asset)mpConfig, "classes/META-INF/microprofile-config.properties");
    }

    @BeforeTest
    public void setupClient() throws Exception {
        this.builtJsonBClient = (JsonBClient)RestClientBuilder.newBuilder().baseUri(InvokeWithJsonBProviderTest.getServerURI()).build(JsonBClient.class);
    }

    @Test
    public void testGetExecutesForBothClients() throws Exception {
        this.testGet(this.builtJsonBClient, BUILT);
        this.testGet(this.cdiJsonBClient, CDI);
    }

    private void testGet(JsonBClient client, String clientType) throws Exception {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/myObject")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"objectName\": \"myObject\",\"quantity\": 17,\"date\": \"2018-12-04\"}")));
        MyJsonBObject obj = client.get("myObject");
        Assert.assertEquals((String)obj.getName(), (String)"myObject");
        Assert.assertEquals((int)obj.getQty(), (int)17);
        Assert.assertEquals((String)obj.getIgnoredField(), (String)"CTOR");
        Assert.assertEquals((Object)obj.getDate(), (Object)LocalDate.of(2018, 12, 4));
    }
}

