/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.io.Closeable;
import java.net.URI;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.StringClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWith200RequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CloseTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(CloseTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ReturnWith200RequestFilter.class, StringClient.class});
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expectIllegalStateExceptionAfterCloseableClose() throws Exception {
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register(ReturnWith200RequestFilter.class);
        StringClient client = (StringClient)builder.baseUri(new URI("http://localhost/stub")).build(StringClient.class);
        try {
            Assert.assertEquals((String)client.getHeaderValue("foo"), (String)"OK");
        }
        catch (Throwable t) {
            Assert.fail((String)"Initial (unclosed) request threw unexpected exception", (Throwable)t);
        }
        try {
            ((Closeable)((Object)client)).close();
        }
        catch (Throwable t) {
            Assert.fail((String)"Caught unexpected exception closing client", (Throwable)t);
        }
        client.getHeaderValue("IllegalStateException expected");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expectIllegalStateExceptionAfterAutoCloseableClose() throws Exception {
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register(ReturnWith200RequestFilter.class);
        StringClient client = (StringClient)builder.baseUri(new URI("http://localhost/stub")).build(StringClient.class);
        try (AutoCloseable ac = (AutoCloseable)((Object)client);){
            Assert.assertEquals((String)client.getHeaderValue("foo"), (String)"OK");
        }
        catch (Throwable t) {
            Assert.fail((String)"Initial (unclosed) request or attempt to close threw unexpected exception", (Throwable)t);
        }
        client.getHeaderValue("IllegalStateException expected");
    }
}

