/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.net.URI;
import java.net.URL;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProvidesRestClientBuilderTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        String simpleName = ProvidesRestClientBuilderTest.class.getSimpleName();
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addClasses(new Class[]{SimpleGetApi.class, ReturnWithURLRequestFilter.class});
    }

    @Test
    public void testCanCallStaticLoader() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testLastBaseUriOrBaseUrlCallWins() throws Exception {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        builder = (RestClientBuilder)builder.register(ReturnWithURLRequestFilter.class);
        builder = builder.baseUri(new URI("http://localhost:8080/wrong1"));
        builder = builder.baseUrl(new URL("http://localhost:8080/right1"));
        SimpleGetApi client = (SimpleGetApi)builder.build(SimpleGetApi.class);
        Assert.assertEquals((String)((String)client.executeGet().readEntity(String.class)), (String)"GET http://localhost:8080/right1");
        builder = builder.baseUrl(new URL("http://localhost:8080/wrong2"));
        builder = builder.baseUri(new URI("http://localhost:8080/wrong2b"));
        builder = builder.baseUri(new URI("http://localhost:8080/right2"));
        client = (SimpleGetApi)builder.build(SimpleGetApi.class);
        Assert.assertEquals((String)((String)client.executeGet().readEntity(String.class)), (String)"GET http://localhost:8080/right2");
    }

    @Test
    public void testIllegalStateExceptionThrownWhenNoBaseUriOrUrlSpecified() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        builder = (RestClientBuilder)builder.register(ReturnWithURLRequestFilter.class);
        try {
            builder.build(SimpleGetApi.class);
            Assert.fail((String)"Did not throw expected IllegalStateException");
        }
        catch (Throwable t) {
            Assert.assertEquals(t.getClass(), IllegalStateException.class);
        }
    }
}

