/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceBase;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceWithProvidersDefined;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceWithoutProvidersDefined;
import org.eclipse.microprofile.rest.client.tck.providers.TestClientRequestFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TestClientResponseFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TestMessageBodyReader;
import org.eclipse.microprofile.rest.client.tck.providers.TestMessageBodyWriter;
import org.eclipse.microprofile.rest.client.tck.providers.TestParamConverterProvider;
import org.eclipse.microprofile.rest.client.tck.providers.TestReaderInterceptor;
import org.eclipse.microprofile.rest.client.tck.providers.TestWriterInterceptor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIInvokeWithRegisteredProvidersTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private InterfaceWithProvidersDefined clientProvidersViaAnnotation;
    @Inject
    @RestClient
    private InterfaceWithoutProvidersDefined clientProvidersViaMPConfig;

    @Deployment
    public static WebArchive createDeployment() {
        String urlPropName1 = InterfaceWithProvidersDefined.class.getName() + "/mp-rest/url";
        String urlPropName2 = InterfaceWithoutProvidersDefined.class.getName() + "/mp-rest/url";
        String urlValue = CDIInvokeWithRegisteredProvidersTest.getStringURL();
        String simpleName = CDIInvokeWithRegisteredProvidersTest.class.getSimpleName();
        String providersPropName = InterfaceWithoutProvidersDefined.class.getName() + "/mp-rest/providers";
        String providersValue = TestClientRequestFilter.class.getName() + "," + TestClientResponseFilter.class.getName() + "," + TestMessageBodyReader.class.getName() + "," + TestMessageBodyWriter.class.getName() + "," + TestParamConverterProvider.class.getName() + "," + TestReaderInterceptor.class.getName() + "," + TestWriterInterceptor.class.getName();
        String propsFile = String.format(urlPropName1 + "=" + urlValue + "%n" + urlPropName2 + "=" + urlValue + "%n" + providersPropName + "=" + providersValue, new Object[0]);
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{InterfaceWithProvidersDefined.class, InterfaceWithoutProvidersDefined.class, InterfaceBase.class, WiremockArquillianTest.class})).addPackage(TestClientResponseFilter.class.getPackage())).addAsManifestResource((Asset)new StringAsset(propsFile), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testInvokesPostOperation_viaAnnotation() throws Exception {
        this.testInvokesPostOperation(this.clientProvidersViaAnnotation);
    }

    @Test
    public void testInvokesPostOperation_viaMPConfig() throws Exception {
        this.testInvokesPostOperation(this.clientProvidersViaMPConfig);
    }

    private void testInvokesPostOperation(InterfaceBase api) throws Exception {
        String inputBody = "input body will be removed";
        String outputBody = "output body will be removed";
        String expectedReceivedBody = "this is the replaced writer " + inputBody;
        String expectedResponseBody = "this is the replaced body";
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withBody(outputBody)));
        Response response = api.executePost(inputBody);
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)expectedResponseBody);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalTo((String)expectedReceivedBody)));
        Assert.assertEquals((int)TestClientResponseFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestClientRequestFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestReaderInterceptor.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestWriterInterceptor.getAndResetValue(), (int)1);
    }

    @Test
    public void testInvokesPutOperation_viaAnnotation() throws Exception {
        this.testInvokesPutOperation(this.clientProvidersViaAnnotation);
    }

    @Test
    public void testInvokesPutOperation_viaMPConfig() throws Exception {
        this.testInvokesPutOperation(this.clientProvidersViaMPConfig);
    }

    private void testInvokesPutOperation(InterfaceBase api) throws Exception {
        String inputBody = "input body will be removed";
        String outputBody = "output body will be removed";
        String expectedReceivedBody = "this is the replaced writer " + inputBody;
        String expectedResponseBody = "this is the replaced body";
        String id = "id";
        String expectedId = "toStringid";
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)("/" + expectedId))).willReturn(WireMock.aResponse().withBody(outputBody)));
        Response response = api.executePut(id, inputBody);
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)expectedResponseBody);
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)("/" + expectedId))).withRequestBody((ContentPattern)WireMock.equalTo((String)expectedReceivedBody)));
        Assert.assertEquals((int)TestClientResponseFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestClientRequestFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestReaderInterceptor.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestWriterInterceptor.getAndResetValue(), (int)1);
    }
}

