/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceUsingBeanParam;
import org.eclipse.microprofile.rest.client.tck.interfaces.MyBean;
import org.eclipse.microprofile.rest.client.tck.providers.BeanParamFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BeanParamTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackage(BeanParamFilter.class.getPackage());
    }

    @Test
    public void sendsParamsSpecifiedInBeanParam() throws Exception {
        BeanParamFilter filter = new BeanParamFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter);
        InterfaceUsingBeanParam client = (InterfaceUsingBeanParam)builder.baseUrl(new URL("http://localhost/stub")).build(InterfaceUsingBeanParam.class);
        MyBean myBean = new MyBean("qParam", "123", "headerVal");
        Response response = client.executePut(myBean);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response - filter not properly registered");
        String responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Null entity returned from filter/server");
        Assert.assertTrue((boolean)responseStr.contains("qParam"), (String)"QueryParam value not sent in request");
        Assert.assertTrue((boolean)responseStr.contains("123"), (String)"CookieParam value not sent in request");
        Assert.assertTrue((boolean)responseStr.contains("headerVal"), (String)"QueryParam value not sent in request");
        myBean.setCookie("456");
        response = client.executePut(myBean);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response - filter not properly registered");
        responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Null entity returned from filter/server");
        Assert.assertTrue((boolean)responseStr.contains("qParam"), (String)"QueryParam value not sent in second request");
        Assert.assertTrue((boolean)responseStr.contains("456"), (String)"CookieParam value not sent in second request");
        Assert.assertTrue((boolean)responseStr.contains("headerVal"), (String)"QueryParam value not sent in second request");
    }
}

