/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.apps.beanvalidation;

import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.apps.beanvalidation.TestGroup;

public class BeanValidationData {
    @NotEmpty
    private String notEmptyString;
    @NotEmpty
    private List<String> notEmptyList;
    @NotEmpty
    private Map<String, String> notEmptyMap;
    @NotBlank
    private String notBlankString;
    @Size(min=2, max=7)
    private @Size(min=2, max=7) String sizedString;
    @Size(min=1, max=10)
    private @Size(min=1, max=10) List<String> sizedList;
    @Size(min=3, max=5)
    private @Size(min=3, max=5) Map<String, String> sizedMap;
    @DecimalMax(value="1.5")
    private @DecimalMax(value="1.5") BigDecimal maxDecimalInclusive;
    @DecimalMax(value="1.5", inclusive=false)
    private @DecimalMax(value="1.5", inclusive=false) BigDecimal maxDecimalExclusive;
    @DecimalMin(value="3.25")
    private @DecimalMin(value="3.25") BigDecimal minDecimalInclusive;
    @DecimalMin(value="3.25", inclusive=false)
    private @DecimalMin(value="3.25", inclusive=false) BigDecimal minDecimalExclusive;
    @Max(value=5L)
    private @Max(value=5L) int maxInt;
    @Min(value=7L)
    private @Min(value=7L) int minInt;
    @Negative
    private int negativeInt;
    @NegativeOrZero
    private int negativeOrZeroInt;
    @Positive
    private int positiveInt;
    @PositiveOrZero
    private int positiveOrZeroInt;
    @Schema(minLength=6)
    @NotEmpty
    private String overridenBySchemaAnnotation;
    @NotEmpty(groups={TestGroup.class})
    private String nonDefaultGroup;
    @NotEmpty(groups={Default.class, TestGroup.class})
    private String defaultAndOtherGroups;

    public String getNotEmptyString() {
        return this.notEmptyString;
    }

    public void setNotEmptyString(String notEmptyString) {
        this.notEmptyString = notEmptyString;
    }

    public List<String> getNotEmptyList() {
        return this.notEmptyList;
    }

    public void setNotEmptyList(List<String> notEmptyList) {
        this.notEmptyList = notEmptyList;
    }

    public Map<String, String> getNotEmptyMap() {
        return this.notEmptyMap;
    }

    public void setNotEmptyMap(Map<String, String> notEmptyMap) {
        this.notEmptyMap = notEmptyMap;
    }

    public String getNotBlankString() {
        return this.notBlankString;
    }

    public void setNotBlankString(String notBlankString) {
        this.notBlankString = notBlankString;
    }

    public String getSizedString() {
        return this.sizedString;
    }

    public void setSizedString(String sizedString) {
        this.sizedString = sizedString;
    }

    public List<String> getSizedList() {
        return this.sizedList;
    }

    public void setSizedList(List<String> sizedList) {
        this.sizedList = sizedList;
    }

    public Map<String, String> getSizedMap() {
        return this.sizedMap;
    }

    public void setSizedMap(Map<String, String> sizedMap) {
        this.sizedMap = sizedMap;
    }

    public BigDecimal getMaxDecimalInclusive() {
        return this.maxDecimalInclusive;
    }

    public void setMaxDecimalInclusive(BigDecimal maxDecimalInclusive) {
        this.maxDecimalInclusive = maxDecimalInclusive;
    }

    public BigDecimal getMaxDecimalExclusive() {
        return this.maxDecimalExclusive;
    }

    public void setMaxDecimalExclusive(BigDecimal maxDecimalExclusive) {
        this.maxDecimalExclusive = maxDecimalExclusive;
    }

    public BigDecimal getMinDecimalInclusive() {
        return this.minDecimalInclusive;
    }

    public void setMinDecimalInclusive(BigDecimal minDecimalInclusive) {
        this.minDecimalInclusive = minDecimalInclusive;
    }

    public BigDecimal getMinDecimalExclusive() {
        return this.minDecimalExclusive;
    }

    public void setMinDecimalExclusive(BigDecimal minDecimalExclusive) {
        this.minDecimalExclusive = minDecimalExclusive;
    }

    public int getMaxInt() {
        return this.maxInt;
    }

    public void setMaxInt(int maxInt) {
        this.maxInt = maxInt;
    }

    public int getMinInt() {
        return this.minInt;
    }

    public void setMinInt(int minInt) {
        this.minInt = minInt;
    }

    public int getNegativeInt() {
        return this.negativeInt;
    }

    public void setNegativeInt(int negativeInt) {
        this.negativeInt = negativeInt;
    }

    public int getNegativeOrZeroInt() {
        return this.negativeOrZeroInt;
    }

    public void setNegativeOrZeroInt(int negativeOrZeroInt) {
        this.negativeOrZeroInt = negativeOrZeroInt;
    }

    public int getPositiveInt() {
        return this.positiveInt;
    }

    public void setPositiveInt(int positiveInt) {
        this.positiveInt = positiveInt;
    }

    public int getPositiveOrZeroInt() {
        return this.positiveOrZeroInt;
    }

    public void setPositiveOrZeroInt(int positiveOrZeroInt) {
        this.positiveOrZeroInt = positiveOrZeroInt;
    }

    public String getOverridenBySchemaAnnotation() {
        return this.overridenBySchemaAnnotation;
    }

    public void setOverridenBySchemaAnnotation(String overridenBySchemaAnnotation) {
        this.overridenBySchemaAnnotation = overridenBySchemaAnnotation;
    }

    public String getNonDefaultGroup() {
        return this.nonDefaultGroup;
    }

    public void setNonDefaultGroup(String nonDefaultGroup) {
        this.nonDefaultGroup = nonDefaultGroup;
    }

    public String getDefaultAndOtherGroups() {
        return this.defaultAndOtherGroups;
    }

    public void setDefaultAndOtherGroups(String defaultAndOtherGroups) {
        this.defaultAndOtherGroups = defaultAndOtherGroups;
    }
}

