/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck.beanvalidation;

import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.apps.beanvalidation.BeanValidationApp;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BeanValidationTest
extends AppTestBase {
    @Deployment(testable=false)
    public static WebArchive buildApp() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"beanValidation.war")).addPackage(BeanValidationApp.class.getPackage());
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void notEmptyStringTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "notEmptyString", Matchers.hasEntry((Object)"minLength", (Object)1));
        BeanValidationTest.assertProperty(vr, "notEmptyString", Matchers.hasEntry((Object)"type", (Object)"string"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void notEmptyListTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "notEmptyList", Matchers.hasEntry((Object)"minItems", (Object)1));
        BeanValidationTest.assertProperty(vr, "notEmptyList", Matchers.hasEntry((Object)"type", (Object)"array"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void notEmptyMapTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "notEmptyMap", Matchers.hasEntry((Object)"minProperties", (Object)1));
        BeanValidationTest.assertProperty(vr, "notEmptyMap", Matchers.hasEntry((Object)"type", (Object)"object"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void notBlankStringTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "notBlankString", Matchers.hasEntry((Object)"pattern", (Object)"\\S"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void sizedStringTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "sizedString", Matchers.hasEntry((Object)"minLength", (Object)2));
        BeanValidationTest.assertProperty(vr, "sizedString", Matchers.hasEntry((Object)"maxLength", (Object)7));
        BeanValidationTest.assertProperty(vr, "sizedString", Matchers.hasEntry((Object)"type", (Object)"string"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void sizedListTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "sizedList", Matchers.hasEntry((Object)"minItems", (Object)1));
        BeanValidationTest.assertProperty(vr, "sizedList", Matchers.hasEntry((Object)"maxItems", (Object)10));
        BeanValidationTest.assertProperty(vr, "sizedList", Matchers.hasEntry((Object)"type", (Object)"array"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void sizedMapTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "sizedMap", Matchers.hasEntry((Object)"minProperties", (Object)3));
        BeanValidationTest.assertProperty(vr, "sizedMap", Matchers.hasEntry((Object)"maxProperties", (Object)5));
        BeanValidationTest.assertProperty(vr, "sizedMap", Matchers.hasEntry((Object)"type", (Object)"object"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void maxDecimalInclusiveTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "maxDecimalInclusive", Matchers.hasEntry((Object)"maximum", (Object)Float.valueOf(1.5f)));
        BeanValidationTest.assertProperty(vr, "maxDecimalInclusive", Matchers.hasEntry((Object)"type", (Object)"number"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void maxDecimalExclusiveTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "maxDecimalExclusive", Matchers.hasEntry((Object)"maximum", (Object)Float.valueOf(1.5f)));
        BeanValidationTest.assertProperty(vr, "maxDecimalExclusive", Matchers.hasEntry((Object)"exclusiveMaximum", (Object)true));
        BeanValidationTest.assertProperty(vr, "maxDecimalExclusive", Matchers.hasEntry((Object)"type", (Object)"number"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void minDecimalInclusiveTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "minDecimalInclusive", Matchers.hasEntry((Object)"minimum", (Object)Float.valueOf(3.25f)));
        BeanValidationTest.assertProperty(vr, "minDecimalInclusive", Matchers.hasEntry((Object)"type", (Object)"number"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void minDecimalExclusiveTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "minDecimalExclusive", Matchers.hasEntry((Object)"minimum", (Object)Float.valueOf(3.25f)));
        BeanValidationTest.assertProperty(vr, "minDecimalExclusive", Matchers.hasEntry((Object)"exclusiveMinimum", (Object)true));
        BeanValidationTest.assertProperty(vr, "minDecimalExclusive", Matchers.hasEntry((Object)"type", (Object)"number"));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void maxIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "maxInt", Matchers.hasEntry((Object)"maximum", (Object)5));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void minIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "minInt", Matchers.hasEntry((Object)"minimum", (Object)7));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void negativeIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "negativeInt", Matchers.hasEntry((Object)"maximum", (Object)0));
        BeanValidationTest.assertProperty(vr, "negativeInt", Matchers.hasEntry((Object)"exclusiveMaximum", (Object)true));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void negativeOrZeroIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "negativeOrZeroInt", Matchers.hasEntry((Object)"maximum", (Object)0));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void positiveIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "positiveInt", Matchers.hasEntry((Object)"minimum", (Object)0));
        BeanValidationTest.assertProperty(vr, "positiveInt", Matchers.hasEntry((Object)"exclusiveMinimum", (Object)true));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void positiveOrZeroIntTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "positiveOrZeroInt", Matchers.hasEntry((Object)"minimum", (Object)0));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void overridenBySchemaAnnotationTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "overridenBySchemaAnnotation", Matchers.hasEntry((Object)"minLength", (Object)6));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void nonDefaultGroupTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "nonDefaultGroup", Matchers.not((Matcher)Matchers.hasKey((Object)"minLength")));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void defaultAndOtherGroupsTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        BeanValidationTest.assertProperty(vr, "defaultAndOtherGroups", Matchers.hasEntry((Object)"minLength", (Object)1));
    }

    @Test(dataProvider="formatProvider", groups={"bean-validation"})
    public void parameterTest(String format) {
        ValidatableResponse vr = this.callEndpoint(format);
        String schemaPath = BeanValidationTest.dereference(vr, "paths.'/parameter/{test}'.post.parameters[0]", "schema");
        vr.body(schemaPath, Matchers.hasEntry((Object)"maxLength", (Object)6), new Object[0]);
        vr.body(schemaPath, Matchers.hasEntry((Object)"type", (Object)"string"), new Object[0]);
    }

    public static void assertProperty(ValidatableResponse vr, String propertyName, Matcher<?> matcher) {
        String schemaPath = BeanValidationTest.dereference(vr, "paths.'/'.post.requestBody", "content.'application/json'.schema");
        String propertyPath = schemaPath + ".properties." + propertyName;
        vr.body(propertyPath, matcher, new Object[0]);
    }
}

