/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.tck.utils.YamlToJsonFilter;
import org.jboss.arquillian.testng.Arquillian;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;

public abstract class AppTestBase
extends Arquillian {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9080;
    private static String serverUrl;
    private static String username;
    private static String password;

    @BeforeSuite
    public static void setUp() throws MalformedURLException {
        serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 9080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 9080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        username = System.getProperty("test.user");
        password = System.getProperty("test.pwd");
        if (username != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)username, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
        RestAssured.defaultParser = Parser.JSON;
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            serverUrl = "http://localhost:9080";
        }
        RestAssured.filters((Filter)new YamlToJsonFilter(), (Filter[])new Filter[0]);
    }

    public ValidatableResponse callEndpoint(String type) {
        ValidatableResponse vr = "JSON".equals(type) ? (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/openapi", new Object[0])).then()).statusCode(200) : (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.ANY).when().get("/openapi", new Object[0])).then()).statusCode(200);
        return vr;
    }

    @DataProvider(name="formatProvider")
    public Object[][] provide() throws Exception {
        return new Object[][]{{"JSON"}, {"YAML"}};
    }
}

