/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Tag;

public class MetricID
implements Comparable<MetricID> {
    public static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    private static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    private final String name;
    private final Map<String, String> tags = new TreeMap<String, String>();

    public MetricID(String name) {
        this(name, null);
    }

    public MetricID(String name, Tag ... tags) {
        this.name = name;
        Optional globalTags = ConfigProvider.getConfig().getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
        globalTags.ifPresent(this::parseGlobalTags);
        this.addTags(tags);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public String getTagsAsString() {
        return this.tags.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
    }

    public List<Tag> getTagsAsList() {
        ArrayList list = new ArrayList();
        this.tags.forEach((key, value) -> list.add(new Tag((String)key, (String)value)));
        return Collections.unmodifiableList(list);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricID)) {
            return false;
        }
        MetricID that = (MetricID)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.tags, that.getTags());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    public String toString() {
        return "MetricID{name='" + this.name + '\'' + ", tags=[" + this.getTagsAsString() + "]}";
    }

    private void addTags(Tag[] tagArray) {
        if (tagArray == null || tagArray.length == 0) {
            return;
        }
        Stream.of(tagArray).forEach(this::addTag);
    }

    private void addTag(Tag tag) {
        if (tag == null || tag.getTagName() == null || tag.getTagValue() == null) {
            return;
        }
        this.tags.put(tag.getTagName(), tag.getTagValue());
    }

    private void parseGlobalTags(String globalTags) throws IllegalArgumentException {
        String[] kvPairs;
        if (globalTags == null || globalTags.length() == 0) {
            return;
        }
        for (String kvString : kvPairs = globalTags.split("(?<!\\\\),")) {
            if (kvString.length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String[] keyValueSplit = kvString.split("(?<!\\\\)=");
            if (keyValueSplit.length != 2 || keyValueSplit[0].length() == 0 || keyValueSplit[1].length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String key = keyValueSplit[0];
            String value = keyValueSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            this.tags.put(key, value);
        }
    }

    @Override
    public int compareTo(MetricID other) {
        int compareVal = this.name.compareTo(other.getName());
        if (compareVal == 0 && (compareVal = this.tags.size() - other.getTags().size()) == 0) {
            Iterator<Map.Entry<String, String>> thisIterator = this.tags.entrySet().iterator();
            Iterator<Map.Entry<String, String>> otherIterator = other.getTags().entrySet().iterator();
            while (thisIterator.hasNext() && otherIterator.hasNext()) {
                Map.Entry<String, String> thisEntry = thisIterator.next();
                Map.Entry<String, String> otherEntry = otherIterator.next();
                compareVal = thisEntry.getKey().compareTo(otherEntry.getKey());
                if (compareVal != 0) {
                    return compareVal;
                }
                compareVal = thisEntry.getValue().compareTo(otherEntry.getValue());
                if (compareVal == 0) continue;
                return compareVal;
            }
        }
        return compareVal;
    }
}

