/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricType;

public class Metadata {
    private String name;
    private String displayName;
    private String description;
    private MetricType type = MetricType.INVALID;
    private String unit = "none";
    private boolean reusable = false;
    private HashMap<String, String> tags = new HashMap();
    public static final String GLOBAL_TAGS_VARIABLE = "MP_METRICS_TAGS";

    Metadata() {
        Optional globalTags = ConfigProvider.getConfig().getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
        globalTags.ifPresent(this::addTags);
    }

    public Metadata(String name, MetricType type) {
        this();
        this.name = name;
        this.type = type;
        switch (type) {
            case TIMER: {
                this.unit = "nanoseconds";
                break;
            }
            case METERED: {
                this.unit = "per_second";
                break;
            }
            default: {
                this.unit = "none";
            }
        }
    }

    public Metadata(String name, MetricType type, String unit) {
        this();
        this.name = name;
        this.type = type;
        this.unit = unit;
    }

    public Metadata(String name, String displayName, String description, MetricType type, String unit) {
        this();
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.unit = unit;
    }

    public Metadata(String name, String displayName, String description, MetricType type, String unit, String tags) {
        this();
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.unit = unit;
        this.addTags(tags);
    }

    public Metadata(Map<String, String> in) {
        this();
        this.name = in.get("name");
        this.description = in.get("description");
        this.displayName = in.get("displayName");
        this.setType(in.get("type"));
        this.setUnit(in.get("unit"));
        if (in.keySet().contains("tags")) {
            String tagString = in.get("tags");
            this.addTags(tagString);
        }
        this.setReusable(Boolean.parseBoolean(in.get("reusable")));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.name;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type == null ? MetricType.INVALID.toString() : this.type.toString();
    }

    public MetricType getTypeRaw() {
        return this.type;
    }

    public void setType(String type) throws IllegalArgumentException {
        this.type = MetricType.from(type);
    }

    public void setType(MetricType type) {
        this.type = type;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }

    public String getTagsAsString() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = this.tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> pair = iterator.next();
            result.append(pair.getKey()).append("=\"").append(pair.getValue()).append("\"");
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    public HashMap<String, String> getTags() {
        return this.tags;
    }

    public void addTag(String kvString) {
        if (kvString == null || kvString.isEmpty() || !kvString.contains("=")) {
            return;
        }
        this.tags.put(kvString.substring(0, kvString.indexOf("=")), kvString.substring(kvString.indexOf("=") + 1));
    }

    public void addTags(String tagsString) {
        String[] singleTags;
        if (tagsString == null || tagsString.isEmpty()) {
            return;
        }
        for (String singleTag : singleTags = tagsString.split(",")) {
            this.addTag(singleTag.trim());
        }
    }

    public void setTags(HashMap<String, String> tags) {
        this.tags = tags;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetadataEntry{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", type='").append((Object)this.type).append('\'');
        sb.append(", unit='").append(this.unit).append('\'');
        sb.append(", tags='").append(this.tags).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

